@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="px-4 py-6 sm:px-0">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900">Agency Campaigns</h1>
            <a href="{{ route('agency.campaigns.create') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                Create Campaign
            </a>
        </div>

        <!-- Brands Section -->
        <div class="mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Linked Brands</h2>
            @if($brands->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($brands as $brand)
                        <div class="bg-white shadow rounded-lg p-4">
                            <h3 class="text-lg font-medium text-gray-900">{{ $brand->name }}</h3>
                            <p class="text-gray-600">{{ $brand->description }}</p>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-gray-500">No brands linked to your agency yet.</p>
            @endif
        </div>

        <!-- Campaigns Section -->
        <div>
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Campaigns</h2>
            @if($campaigns->count() > 0)
                <div class="bg-white shadow overflow-hidden sm:rounded-md">
                    <ul class="divide-y divide-gray-200">
                        @foreach($campaigns as $campaign)
                            <li>
                                <div class="px-4 py-4 sm:px-6">
                                    <div class="flex items-center justify-between">
                                        <p class="text-sm font-medium text-blue-600 truncate">
                                            {{ $campaign->name }}
                                        </p>
                                        <div class="ml-2 flex-shrink-0 flex">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                {{ $campaign->status }}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="mt-2 sm:flex sm:justify-between">
                                        <div class="sm:flex">
                                            <p class="flex items-center text-sm text-gray-500">
                                                Brand: {{ $campaign->brand->name }}
                                            </p>
                                        </div>
                                        <div class="mt-2 flex items-center text-sm text-gray-500 sm:mt-0">
                                            <p>
                                                Budget: ${{ number_format($campaign->budget, 2) }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="mt-2 sm:flex sm:justify-between">
                                        <div class="sm:flex">
                                            <p class="flex items-center text-sm text-gray-500">
                                                Start Date: {{ $campaign->start_date->format('M d, Y') }}
                                            </p>
                                        </div>
                                        <div class="mt-2 flex items-center text-sm text-gray-500 sm:mt-0">
                                            <p>
                                                End Date: {{ $campaign->end_date->format('M d, Y') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="mt-4 flex space-x-4">
                                        <a href="{{ route('agency.campaigns.edit', $campaign) }}" class="text-indigo-600 hover:text-indigo-900">
                                            Edit
                                        </a>
                                        <form action="{{ route('agency.campaigns.destroy', $campaign) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure you want to delete this campaign?')">
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @else
                <p class="text-gray-500">No campaigns created yet.</p>
            @endif
        </div>
    </div>
</div>
@endsection