@extends('layouts.brand')

@section('title', 'Create New Ad')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">Create New Ad</h1>
                <a href="{{ route('brand.ads.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Ads
                </a>
            </div>
        </div>
    </div>

    <form action="{{ route('brand.ads.store') }}" method="POST" id="adForm">
        @csrf
        
        <div class="row">
            <!-- Left Column: Ad Builder Form -->
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Ad Details</h5>
                    </div>
                    <div class="card-body">
                        <!-- Campaign Selection -->
                        <div class="mb-3">
                            <label for="campaign_id" class="form-label">Campaign <span class="text-danger">*</span></label>
                            <select name="campaign_id" id="campaign_id" class="form-select @error('campaign_id') is-invalid @enderror" required>
                                <option value="">Select a campaign</option>
                                @foreach($campaigns as $campaign)
                                    <option value="{{ $campaign->id }}" {{ old('campaign_id') == $campaign->id ? 'selected' : '' }}>
                                        {{ $campaign->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('campaign_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Ad Name -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Ad Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" 
                                   value="{{ old('name') }}" placeholder="e.g., Summer Sale Campaign - Facebook" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Product/Service Information -->
                        <div class="mb-3">
                            <label for="product_info" class="form-label">Product/Service Information <span class="text-danger">*</span></label>
                            <textarea name="product_info" id="product_info" rows="4" 
                                      class="form-control @error('product_info') is-invalid @enderror" 
                                      placeholder="Describe your product or service, key features, benefits, unique selling points..." required>{{ old('product_info') }}</textarea>
                            <small class="form-text text-muted">
                                Provide detailed information about what you're advertising. This helps AI generate better ad copy.
                            </small>
                            @error('product_info')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Target Audience -->
                        <div class="mb-3">
                            <label for="audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                            <textarea name="audience" id="audience" rows="3" 
                                      class="form-control @error('audience') is-invalid @enderror" 
                                      placeholder="e.g., Young professionals aged 25-35, interested in fitness and wellness..." required>{{ old('audience') }}</textarea>
                            <small class="form-text text-muted">
                                Describe your target audience demographics, interests, and behaviors.
                            </small>
                            @error('audience')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Tone -->
                        <div class="mb-3">
                            <label for="tone" class="form-label">Tone & Style <span class="text-danger">*</span></label>
                            <select name="tone" id="tone" class="form-select @error('tone') is-invalid @enderror" required>
                                <option value="">Select tone</option>
                                <option value="professional" {{ old('tone') == 'professional' ? 'selected' : '' }}>Professional</option>
                                <option value="casual" {{ old('tone') == 'casual' ? 'selected' : '' }}>Casual & Friendly</option>
                                <option value="enthusiastic" {{ old('tone') == 'enthusiastic' ? 'selected' : '' }}>Enthusiastic & Energetic</option>
                                <option value="authoritative" {{ old('tone') == 'authoritative' ? 'selected' : '' }}>Authoritative & Expert</option>
                                <option value="humorous" {{ old('tone') == 'humorous' ? 'selected' : '' }}>Humorous & Playful</option>
                                <option value="empathetic" {{ old('tone') == 'empathetic' ? 'selected' : '' }}>Empathetic & Caring</option>
                                <option value="urgent" {{ old('tone') == 'urgent' ? 'selected' : '' }}>Urgent & Action-Oriented</option>
                            </select>
                            @error('tone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Budget -->
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="budget" class="form-label">Budget</label>
                                    <input type="number" name="budget" id="budget" step="0.01" min="0" 
                                           class="form-control @error('budget') is-invalid @enderror" 
                                           value="{{ old('budget') }}" placeholder="0.00">
                                    @error('budget')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="currency" class="form-label">Currency</label>
                                    <select name="currency" id="currency" class="form-select @error('currency') is-invalid @enderror">
                                        <option value="USD" {{ old('currency', 'USD') == 'USD' ? 'selected' : '' }}>USD</option>
                                        <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>EUR</option>
                                        <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>GBP</option>
                                        <option value="INR" {{ old('currency') == 'INR' ? 'selected' : '' }}>INR</option>
                                    </select>
                                    @error('currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Number of Variants -->
                        <div class="mb-3">
                            <label for="num_variants" class="form-label">Number of AI-Generated Variants <span class="text-danger">*</span></label>
                            <select name="num_variants" id="num_variants" class="form-select @error('num_variants') is-invalid @enderror" required>
                                <option value="2" {{ old('num_variants', 3) == 2 ? 'selected' : '' }}>2 variants</option>
                                <option value="3" {{ old('num_variants', 3) == 3 ? 'selected' : '' }}>3 variants (Recommended)</option>
                                <option value="4" {{ old('num_variants') == 4 ? 'selected' : '' }}>4 variants</option>
                                <option value="5" {{ old('num_variants') == 5 ? 'selected' : '' }}>5 variants</option>
                            </select>
                            <small class="form-text text-muted">
                                AI will generate multiple ad copy variants with different approaches for A/B testing.
                            </small>
                            @error('num_variants')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Preview & Info -->
            <div class="col-lg-4">
                <div class="card mb-4 sticky-top" style="top: 20px;">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>How It Works</h5>
                    </div>
                    <div class="card-body">
                        <ol class="ps-3">
                            <li class="mb-2">
                                <strong>Fill in the details</strong>
                                <p class="small text-muted mb-0">Provide information about your product, audience, and desired tone.</p>
                            </li>
                            <li class="mb-2">
                                <strong>AI generates variants</strong>
                                <p class="small text-muted mb-0">Our AI creates multiple ad copy variants with different creative approaches.</p>
                            </li>
                            <li class="mb-2">
                                <strong>Review & select</strong>
                                <p class="small text-muted mb-0">Review the generated variants and select which ones to launch.</p>
                            </li>
                            <li class="mb-2">
                                <strong>Launch A/B test</strong>
                                <p class="small text-muted mb-0">Launch selected variants across platforms and track performance.</p>
                            </li>
                            <li class="mb-0">
                                <strong>Optimize</strong>
                                <p class="small text-muted mb-0">Analyze results and promote the winning variant.</p>
                            </li>
                        </ol>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="fas fa-lightbulb me-2"></i>Tips</h5>
                    </div>
                    <div class="card-body">
                        <ul class="small mb-0 ps-3">
                            <li class="mb-2">Be specific about your product's unique features and benefits</li>
                            <li class="mb-2">Clearly define your target audience demographics</li>
                            <li class="mb-2">Choose a tone that matches your brand voice</li>
                            <li class="mb-0">Generate 3-4 variants for optimal A/B testing</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="{{ route('brand.ads.index') }}" class="btn btn-outline-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-magic me-2"></i>Generate Ad Variants
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form validation feedback
    const form = document.getElementById('adForm');
    
    form.addEventListener('submit', function(e) {
        const submitBtn = form.querySelector('button[type="submit"]');
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Generating Variants...';
    });
});
</script>
@endpush
@endsection