@extends('layouts.brand')

@section('title', 'Ad Details - ' . $ad->name)

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-1">{{ $ad->name }}</h1>
                    <p class="text-muted mb-0">
                        Campaign: <a href="{{ route('brand.campaigns.show', $ad->campaign) }}">{{ $ad->campaign->name }}</a>
                    </p>
                </div>
                <div class="btn-group">
                    <a href="{{ route('brand.ads.ab-test', $ad) }}" class="btn btn-info">
                        <i class="fas fa-chart-line me-2"></i>A/B Test Dashboard
                    </a>
                    <a href="{{ route('brand.ads.edit', $ad) }}" class="btn btn-outline-secondary">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <a href="{{ route('brand.ads.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Ad Overview -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Status</h6>
                    <span class="badge bg-{{ $ad->status === 'active' ? 'success' : ($ad->status === 'paused' ? 'warning' : 'secondary') }} fs-6">
                        {{ ucfirst($ad->status) }}
                    </span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Total Variants</h6>
                    <h3 class="mb-0">{{ $ad->variants->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Active Variants</h6>
                    <h3 class="mb-0">{{ $ad->activeVariants()->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Budget</h6>
                    <h3 class="mb-0">{{ $ad->currency }} {{ number_format($ad->budget, 2) }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Ad Details -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Ad Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6 class="text-muted">Product/Service Information</h6>
                            <p>{{ $ad->product_info }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <h6 class="text-muted">Target Audience</h6>
                            <p>{{ $ad->audience }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-muted">Tone & Style</h6>
                            <p>{{ ucfirst($ad->tone) }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-muted">Created</h6>
                            <p>{{ $ad->created_at->format('F d, Y \a\t h:i A') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Ad Variants -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Ad Variants</h5>
                    <div>
                        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#regenerateModal">
                            <i class="fas fa-sync me-2"></i>Regenerate Variants
                        </button>
                        <button type="button" class="btn btn-sm btn-success" onclick="launchSelectedVariants()">
                            <i class="fas fa-rocket me-2"></i>Launch Selected
                        </button>
                        <button type="button" class="btn btn-sm btn-warning" onclick="pauseSelectedVariants()">
                            <i class="fas fa-pause me-2"></i>Pause Selected
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    @if($ad->variants->count() > 0)
                        <form id="variantSelectionForm">
                            @csrf
                            <div class="row">
                                @foreach($ad->variants as $variant)
                                    <div class="col-md-6 col-lg-4 mb-4">
                                        <div class="card h-100 {{ $variant->is_winner ? 'border-warning' : '' }} {{ $variant->is_active ? 'border-success' : '' }}">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <div class="form-check">
                                                    <input class="form-check-input variant-checkbox" type="checkbox" 
                                                           value="{{ $variant->id }}" id="variant{{ $variant->id }}">
                                                    <label class="form-check-label fw-bold" for="variant{{ $variant->id }}">
                                                        Variant #{{ $loop->iteration }}
                                                    </label>
                                                </div>
                                                <div>
                                                    @if($variant->is_winner)
                                                        <span class="badge bg-warning text-dark">
                                                            <i class="fas fa-trophy"></i> Winner
                                                        </span>
                                                    @endif
                                                    @if($variant->is_active)
                                                        <span class="badge bg-success">Active</span>
                                                    @else
                                                        <span class="badge bg-secondary">Inactive</span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <h6 class="text-muted small mb-1">HEADLINE</h6>
                                                    <p class="fw-bold mb-0">{{ $variant->headline }}</p>
                                                </div>
                                                <div class="mb-3">
                                                    <h6 class="text-muted small mb-1">BODY</h6>
                                                    <p class="mb-0">{{ $variant->body }}</p>
                                                </div>
                                                <div class="mb-3">
                                                    <h6 class="text-muted small mb-1">CALL TO ACTION</h6>
                                                    <p class="mb-0">
                                                        <span class="badge bg-primary">{{ $variant->cta }}</span>
                                                    </p>
                                                </div>
                                                
                                                @if($variant->predicted_metrics)
                                                    <div class="mb-3">
                                                        <h6 class="text-muted small mb-2">PREDICTED PERFORMANCE</h6>
                                                        <div class="small">
                                                            <div class="d-flex justify-content-between mb-1">
                                                                <span>CTR:</span>
                                                                <span class="fw-bold">{{ $variant->predicted_metrics['predicted_ctr'] ?? 'N/A' }}%</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between mb-1">
                                                                <span>Conv. Rate:</span>
                                                                <span class="fw-bold">{{ $variant->predicted_metrics['predicted_conversion_rate'] ?? 'N/A' }}%</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between">
                                                                <span>Confidence:</span>
                                                                <span class="fw-bold">{{ $variant->predicted_metrics['confidence_score'] ?? 'N/A' }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif

                                                @if($variant->performanceMetrics->count() > 0)
                                                    <div class="mb-3">
                                                        <h6 class="text-muted small mb-2">ACTUAL PERFORMANCE</h6>
                                                        @php
                                                            $totalImpressions = $variant->performanceMetrics->sum('impressions');
                                                            $totalClicks = $variant->performanceMetrics->sum('clicks');
                                                            $totalConversions = $variant->performanceMetrics->sum('conversions');
                                                            $avgCTR = $variant->performanceMetrics->avg('ctr');
                                                        @endphp
                                                        <div class="small">
                                                            <div class="d-flex justify-content-between mb-1">
                                                                <span>Impressions:</span>
                                                                <span class="fw-bold">{{ number_format($totalImpressions) }}</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between mb-1">
                                                                <span>Clicks:</span>
                                                                <span class="fw-bold">{{ number_format($totalClicks) }}</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between mb-1">
                                                                <span>Conversions:</span>
                                                                <span class="fw-bold">{{ number_format($totalConversions) }}</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between">
                                                                <span>Avg CTR:</span>
                                                                <span class="fw-bold">{{ number_format($avgCTR, 2) }}%</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="card-footer">
                                                <div class="btn-group btn-group-sm w-100">
                                                    <form action="{{ route('brand.ads.variants.duplicate', $variant) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-outline-secondary" title="Duplicate">
                                                            <i class="fas fa-copy"></i>
                                                        </button>
                                                    </form>
                                                    @if(!$variant->is_winner)
                                                        <form action="{{ route('brand.ads.variants.promote', $variant) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            <button type="submit" class="btn btn-outline-warning" title="Promote as Winner">
                                                                <i class="fas fa-trophy"></i>
                                                            </button>
                                                        </form>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </form>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No variants generated yet.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Regenerate Variants Modal -->
<div class="modal fade" id="regenerateModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('brand.ads.regenerate-variants', $ad) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Regenerate Ad Variants</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Generate new AI-powered ad copy variants for this ad.</p>
                    <div class="mb-3">
                        <label for="num_variants" class="form-label">Number of Variants</label>
                        <select name="num_variants" id="num_variants" class="form-select" required>
                            <option value="2">2 variants</option>
                            <option value="3" selected>3 variants</option>
                            <option value="4">4 variants</option>
                            <option value="5">5 variants</option>
                        </select>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        New variants will be added to your existing ones.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-magic me-2"></i>Generate Variants
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function launchSelectedVariants() {
    const selectedVariants = getSelectedVariants();
    if (selectedVariants.length === 0) {
        alert('Please select at least one variant to launch.');
        return;
    }
    
    if (confirm(`Launch ${selectedVariants.length} selected variant(s)?`)) {
        submitVariantAction('{{ route('brand.ads.launch-variants', $ad) }}', selectedVariants);
    }
}

function pauseSelectedVariants() {
    const selectedVariants = getSelectedVariants();
    if (selectedVariants.length === 0) {
        alert('Please select at least one variant to pause.');
        return;
    }
    
    if (confirm(`Pause ${selectedVariants.length} selected variant(s)?`)) {
        submitVariantAction('{{ route('brand.ads.pause-variants', $ad) }}', selectedVariants);
    }
}

function getSelectedVariants() {
    const checkboxes = document.querySelectorAll('.variant-checkbox:checked');
    return Array.from(checkboxes).map(cb => cb.value);
}

function submitVariantAction(url, variantIds) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = url;
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]').content;
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '_token';
    csrfInput.value = csrfToken;
    form.appendChild(csrfInput);
    
    variantIds.forEach(id => {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'variant_ids[]';
        input.value = id;
        form.appendChild(input);
    });
    
    document.body.appendChild(form);
    form.submit();
}
</script>
@endpush
@endsection