@extends('adminlte::page')

@section('title', 'Social Connections')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Social Connections</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Connections</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Connected Accounts</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Platform</th>
                                        <th>Account</th>
                                        <th>Followers</th>
                                        <th>Connected At</th>
                                        <th>Last Synced</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($accounts as $account)
                                    <tr>
                                        <td>
                                            <i class="fab fa-{{ $account->provider }} mr-1"></i>
                                            {{ ucfirst($account->provider) }}
                                        </td>
                                        <td>
                                            @if($account->is_demo)
                                            <span class="badge badge-warning">Demo Account</span>
                                            @else
                                            {{ $account->meta['username'] ?? $account->meta['name'] ?? $account->provider_user_id }}
                                            @endif
                                        </td>
                                        <td>{{ number_format($account->meta['followers'] ?? 0) }}</td>
                                        <td>{{ $account->connected_at ? $account->connected_at->format('M j, Y H:i') : 'N/A' }}</td>
                                        <td>{{ $account->last_synced_at ? $account->last_synced_at->format('M j, Y H:i') : 'Never' }}</td>
                                        <td>
                                            @if($account->is_demo)
                                            <span class="badge badge-warning">Demo</span>
                                            @elseif($account->isTokenExpired())
                                            <span class="badge badge-danger">Token Expired</span>
                                            @else
                                            <span class="badge badge-success">Active</span>
                                            @endif
                                        </td>
                                        <td>
                                            <form action="{{ route('brand.connections.destroy', $account->id) }}" method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" 
                                                        onclick="return confirm('Are you sure you want to disconnect this account?')">
                                                    Disconnect
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No social accounts connected yet.</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#connectModal">
                            <i class="fas fa-link"></i> Connect New Account
                        </button>
                        <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#manualTokenModal">
                            <i class="fas fa-key"></i> Add Manual Token
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Connect Modal -->
<div class="modal fade" id="connectModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Connect Social Account</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Select a platform to connect:</p>
                <div class="row">
                    @foreach($providers as $slug => $name)
                    <div class="col-6 mb-2">
                        <a href="{{ route('brand.connections.connect', $slug) }}" class="btn btn-block btn-outline-primary">
                            <i class="fab fa-{{ $slug }} mr-1"></i> {{ $name }}
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Manual Token Modal -->
<div class="modal fade" id="manualTokenModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{ route('brand.connections.manual') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Manual Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="provider">Platform</label>
                        <select name="provider" id="provider" class="form-control" required>
                            <option value="">Select Platform</option>
                            @foreach($providers as $slug => $name)
                            <option value="{{ $slug }}">{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="provider_user_id">Account ID</label>
                        <input type="text" name="provider_user_id" id="provider_user_id" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="access_token">Access Token</label>
                        <input type="text" name="access_token" id="access_token" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Add Account</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection