@extends('adminlte::page')

@section('title', 'Create Performance Forecast')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Create Performance Forecast</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.forecasts.index') }}">Forecasts</a></li>
                    <li class="breadcrumb-item active">Create</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Forecast Configuration</h3>
                    </div>
                    <form action="{{ route('brand.forecasts.store') }}" method="POST" id="forecastForm">
                        @csrf
                        <div class="card-body">
                            <!-- Historical Data Period -->
                            <div class="form-group">
                                <label for="start_date">Historical Data Start Date</label>
                                <input type="date" 
                                       class="form-control @error('start_date') is-invalid @enderror" 
                                       id="start_date" 
                                       name="start_date" 
                                       value="{{ old('start_date', now()->subDays(60)->format('Y-m-d')) }}"
                                       max="{{ now()->format('Y-m-d') }}"
                                       required>
                                @error('start_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">Select the start date for historical data analysis</small>
                            </div>

                            <div class="form-group">
                                <label for="end_date">Historical Data End Date</label>
                                <input type="date" 
                                       class="form-control @error('end_date') is-invalid @enderror" 
                                       id="end_date" 
                                       name="end_date" 
                                       value="{{ old('end_date', now()->format('Y-m-d')) }}"
                                       max="{{ now()->format('Y-m-d') }}"
                                       required>
                                @error('end_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">Select the end date for historical data analysis</small>
                            </div>

                            <!-- Forecast Period -->
                            <div class="form-group">
                                <label for="forecast_days">Forecast Period (Days)</label>
                                <select class="form-control @error('forecast_days') is-invalid @enderror" 
                                        id="forecast_days" 
                                        name="forecast_days" 
                                        required>
                                    <option value="7" {{ old('forecast_days') == 7 ? 'selected' : '' }}>7 Days</option>
                                    <option value="14" {{ old('forecast_days') == 14 ? 'selected' : '' }}>14 Days</option>
                                    <option value="30" {{ old('forecast_days', 30) == 30 ? 'selected' : '' }}>30 Days</option>
                                    <option value="60" {{ old('forecast_days') == 60 ? 'selected' : '' }}>60 Days</option>
                                    <option value="90" {{ old('forecast_days') == 90 ? 'selected' : '' }}>90 Days</option>
                                </select>
                                @error('forecast_days')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">How many days ahead to forecast</small>
                            </div>

                            <!-- Scenario Selection -->
                            <div class="form-group">
                                <label for="scenario">Forecast Scenario</label>
                                <select class="form-control @error('scenario') is-invalid @enderror" 
                                        id="scenario" 
                                        name="scenario" 
                                        required>
                                    <option value="conservative" {{ old('scenario') == 'conservative' ? 'selected' : '' }}>
                                        Conservative (95% growth rate)
                                    </option>
                                    <option value="balanced" {{ old('scenario', 'balanced') == 'balanced' ? 'selected' : '' }}>
                                        Balanced (105% growth rate)
                                    </option>
                                    <option value="aggressive" {{ old('scenario') == 'aggressive' ? 'selected' : '' }}>
                                        Aggressive (115% growth rate)
                                    </option>
                                </select>
                                @error('scenario')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">Choose the forecast strategy</small>
                            </div>

                            <!-- Campaign Selection -->
                            <div class="form-group">
                                <label for="campaign_ids">Campaigns (Optional)</label>
                                <select class="form-control select2 @error('campaign_ids') is-invalid @enderror" 
                                        id="campaign_ids" 
                                        name="campaign_ids[]" 
                                        multiple>
                                    @foreach($campaigns as $campaign)
                                        <option value="{{ $campaign->id }}" 
                                                {{ in_array($campaign->id, old('campaign_ids', [])) ? 'selected' : '' }}>
                                            {{ $campaign->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('campaign_ids')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">Leave empty to forecast all campaigns</small>
                            </div>

                            <!-- Social Account Selection -->
                            <div class="form-group">
                                <label for="social_account_ids">Social Accounts (Optional)</label>
                                <select class="form-control select2 @error('social_account_ids') is-invalid @enderror" 
                                        id="social_account_ids" 
                                        name="social_account_ids[]" 
                                        multiple>
                                    @foreach($socialAccounts as $account)
                                        <option value="{{ $account->id }}" 
                                                {{ in_array($account->id, old('social_account_ids', [])) ? 'selected' : '' }}>
                                            {{ ucfirst($account->provider) }} - {{ $account->meta['username'] ?? 'Account' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('social_account_ids')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">Leave empty to forecast all social accounts</small>
                            </div>

                            <!-- Info Box -->
                            <div class="alert alert-info">
                                <h5><i class="icon fas fa-info-circle"></i> How it works:</h5>
                                <ul class="mb-0">
                                    <li>The system analyzes historical performance data from your selected period</li>
                                    <li>AI algorithms predict future performance based on trends and patterns</li>
                                    <li>You'll receive actionable insights and ROI estimates</li>
                                    <li>Processing typically takes 1-2 minutes</li>
                                </ul>
                            </div>
                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-chart-line"></i> Generate Forecast
                            </button>
                            <a href="{{ route('brand.forecasts.index') }}" class="btn btn-secondary">
                                Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css" rel="stylesheet" />
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap4',
        placeholder: 'Select options...',
        allowClear: true
    });

    // Date validation
    const startDate = document.getElementById('start_date');
    const endDate = document.getElementById('end_date');

    startDate.addEventListener('change', function() {
        endDate.min = this.value;
    });

    endDate.addEventListener('change', function() {
        startDate.max = this.value;
    });
});
</script>
@endsection