@extends('adminlte::page')

@section('title', 'Forecast Details')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Forecast #{{ $forecast->id }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.forecasts.index') }}">Forecasts</a></li>
                    <li class="breadcrumb-item active">Details</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <!-- Status Alert -->
        @if($forecast->status === 'processing')
            <div class="alert alert-warning">
                <i class="fas fa-spinner fa-spin"></i> Forecast is being processed. This page will auto-refresh.
            </div>
        @elseif($forecast->status === 'failed')
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle"></i> Forecast processing failed: {{ $forecast->error_message }}
            </div>
        @elseif($forecast->status === 'pending')
            <div class="alert alert-info">
                <i class="fas fa-clock"></i> Forecast is queued for processing.
            </div>
        @endif

        <!-- Forecast Info Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Forecast Information</h3>
                        <div class="card-tools">
                            @if($forecast->isCompleted())
                                <a href="{{ route('brand.forecasts.export', $forecast) }}" class="btn btn-sm btn-success">
                                    <i class="fas fa-download"></i> Export
                                </a>
                            @endif
                            <a href="{{ route('brand.forecasts.index') }}" class="btn btn-sm btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <strong>Created:</strong><br>
                                {{ $forecast->created_at->format('M d, Y H:i') }}
                            </div>
                            <div class="col-md-3">
                                <strong>Historical Period:</strong><br>
                                {{ $forecast->start_date->format('M d') }} - {{ $forecast->end_date->format('M d, Y') }}
                            </div>
                            <div class="col-md-3">
                                <strong>Forecast Period:</strong><br>
                                {{ $forecast->forecast_days }} days
                            </div>
                            <div class="col-md-3">
                                <strong>Scenario:</strong><br>
                                <span class="badge badge-{{ $forecast->scenario === 'aggressive' ? 'danger' : ($forecast->scenario === 'conservative' ? 'secondary' : 'info') }}">
                                    {{ ucfirst($forecast->scenario) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if($forecast->isCompleted())
            <!-- KPI Cards -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{ number_format($forecast->roi_estimates['roi'] ?? 0, 2) }}%</h3>
                            <p>Predicted ROI</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ number_format($forecast->roi_estimates['reach'] ?? 0) }}</h3>
                            <p>Predicted Reach</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{ number_format($forecast->roi_estimates['conversions'] ?? 0) }}</h3>
                            <p>Predicted Conversions</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{ number_format($forecast->roi_estimates['engagement_rate'] ?? 0, 2) }}%</h3>
                            <p>Predicted Engagement</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-heart"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Predicted vs Historical Performance</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="forecastChart" height="80"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Engagement Forecast</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="engagementChart" height="100"></canvas>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Conversions Forecast</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="conversionsChart" height="100"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Insights -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">AI-Generated Insights</h3>
                        </div>
                        <div class="card-body">
                            @if($forecast->insights_text)
                                <div class="alert alert-info">
                                    <i class="fas fa-lightbulb"></i> {{ $forecast->insights_text }}
                                </div>
                            @endif

                            @if(!empty($forecast->getActionableInsights()))
                                <h5>Actionable Recommendations:</h5>
                                <div class="row">
                                    @foreach($forecast->getActionableInsights() as $insight)
                                        <div class="col-md-6 mb-3">
                                            <div class="card border-left-{{ $insight['type'] === 'positive' ? 'success' : ($insight['type'] === 'warning' ? 'warning' : 'info') }}">
                                                <div class="card-body">
                                                    <h6 class="font-weight-bold">{{ $insight['title'] }}</h6>
                                                    <p class="mb-2">{{ $insight['description'] }}</p>
                                                    <small class="text-muted">
                                                        <i class="fas fa-arrow-right"></i> <strong>Action:</strong> {{ $insight['action'] }}
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Metrics -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detailed Metrics</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Metric</th>
                                            <th>Predicted Value</th>
                                            <th>Confidence Interval</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Total Impressions</td>
                                            <td>{{ number_format($forecast->roi_estimates['total_impressions'] ?? 0) }}</td>
                                            <td>±{{ number_format(($forecast->roi_estimates['total_impressions'] ?? 0) * 0.1) }}</td>
                                        </tr>
                                        <tr>
                                            <td>Total Clicks</td>
                                            <td>{{ number_format($forecast->roi_estimates['total_clicks'] ?? 0) }}</td>
                                            <td>±{{ number_format(($forecast->roi_estimates['total_clicks'] ?? 0) * 0.1) }}</td>
                                        </tr>
                                        <tr>
                                            <td>Total Engagement</td>
                                            <td>{{ number_format($forecast->roi_estimates['total_engagement'] ?? 0) }}</td>
                                            <td>±{{ number_format(($forecast->roi_estimates['total_engagement'] ?? 0) * 0.1) }}</td>
                                        </tr>
                                        <tr>
                                            <td>CTR</td>
                                            <td>{{ number_format($forecast->roi_estimates['ctr'] ?? 0, 2) }}%</td>
                                            <td>±{{ number_format(($forecast->roi_estimates['ctr'] ?? 0) * 0.1, 2) }}%</td>
                                        </tr>
                                        <tr>
                                            <td>Conversion Rate</td>
                                            <td>{{ number_format($forecast->roi_estimates['conversion_rate'] ?? 0, 2) }}%</td>
                                            <td>±{{ number_format(($forecast->roi_estimates['conversion_rate'] ?? 0) * 0.1, 2) }}%</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    @if($forecast->status === 'processing' || $forecast->status === 'pending')
        // Auto-refresh for processing forecasts
        setTimeout(function() {
            location.reload();
        }, 5000);
    @endif

    @if($forecast->isCompleted())
        // Load forecast data
        fetch('{{ route('brand.forecasts.data', $forecast) }}')
            .then(response => response.json())
            .then(data => {
                // Main forecast chart
                const forecastCtx = document.getElementById('forecastChart').getContext('2d');
                new Chart(forecastCtx, {
                    type: 'line',
                    data: {
                        labels: data.predicted_timeseries.dates,
                        datasets: [{
                            label: 'Predicted Impressions',
                            data: data.predicted_timeseries.impressions,
                            borderColor: 'rgb(75, 192, 192)',
                            backgroundColor: 'rgba(75, 192, 192, 0.1)',
                            tension: 0.4,
                            fill: true
                        }, {
                            label: 'Upper Bound (95% CI)',
                            data: data.error_bands.impressions.upper,
                            borderColor: 'rgba(75, 192, 192, 0.3)',
                            borderDash: [5, 5],
                            fill: false,
                            pointRadius: 0
                        }, {
                            label: 'Lower Bound (95% CI)',
                            data: data.error_bands.impressions.lower,
                            borderColor: 'rgba(75, 192, 192, 0.3)',
                            borderDash: [5, 5],
                            fill: false,
                            pointRadius: 0
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            tooltip: {
                                mode: 'index',
                                intersect: false
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });

                // Engagement chart
                const engagementCtx = document.getElementById('engagementChart').getContext('2d');
                new Chart(engagementCtx, {
                    type: 'line',
                    data: {
                        labels: data.predicted_timeseries.dates,
                        datasets: [{
                            label: 'Predicted Engagement',
                            data: data.predicted_timeseries.engagement,
                            borderColor: 'rgb(255, 99, 132)',
                            backgroundColor: 'rgba(255, 99, 132, 0.1)',
                            tension: 0.4,
                            fill: true
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });

                // Conversions chart
                const conversionsCtx = document.getElementById('conversionsChart').getContext('2d');
                new Chart(conversionsCtx, {
                    type: 'bar',
                    data: {
                        labels: data.predicted_timeseries.dates,
                        datasets: [{
                            label: 'Predicted Conversions',
                            data: data.predicted_timeseries.conversions,
                            backgroundColor: 'rgba(255, 206, 86, 0.6)',
                            borderColor: 'rgb(255, 206, 86)',
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            })
            .catch(error => {
                console.error('Error loading forecast data:', error);
            });
    @endif
});
</script>

<style>
.border-left-success {
    border-left: 4px solid #28a745 !important;
}
.border-left-warning {
    border-left: 4px solid #ffc107 !important;
}
.border-left-info {
    border-left: 4px solid #17a2b8 !important;
}
</style>
@endsection