@extends('adminlte::page')

@section('title', 'My Shortlists')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">My Shortlists</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.marketplace.index') }}">Marketplace</a></li>
                    <li class="breadcrumb-item active">Shortlists</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Shortlists</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($shortlists->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Description</th>
                                            <th>Creators</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($shortlists as $shortlist)
                                            <tr>
                                                <td>{{ $shortlist->name }}</td>
                                                <td>{{ $shortlist->description ?? 'No description' }}</td>
                                                <td>{{ $shortlist->creators->count() }}</td>
                                                <td>{{ $shortlist->created_at->format('M j, Y') }}</td>
                                                <td>
                                                    <a href="{{ route('brand.marketplace.shortlists.show', $shortlist) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm" 
                                                            onclick="deleteShortlist({{ $shortlist->id }})">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $shortlists->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-list fa-3x text-muted mb-3"></i>
                                <h4>No shortlists found</h4>
                                <p class="text-muted">
                                    You haven't created any shortlists yet.
                                </p>
                                <a href="{{ route('brand.marketplace.index') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Shortlist
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete shortlist function
    window.deleteShortlist = function(shortlistId) {
        if (confirm('Are you sure you want to delete this shortlist?')) {
            // This would make an AJAX call to delete the shortlist
            alert('Delete shortlist functionality would be implemented here');
        }
    };
});
</script>
@endsection