@extends('adminlte::page')

@section('title', 'Create AI Proposal')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Create AI Proposal</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.proposals.index') }}">Proposals</a></li>
                    <li class="breadcrumb-item active">Create AI Proposal</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Proposal Details</h3>
                    </div>
                    <div class="card-body">
                        <form id="aiProposalForm">
                            @csrf
                            
                            <div class="form-group">
                                <label for="creator_id">Creator (Optional)</label>
                                <select name="creator_id" id="creator_id" class="form-control">
                                    <option value="">Select a creator (optional)</option>
                                    @foreach($creators as $c)
                                        <option value="{{ $c->id }}" {{ (isset($creator) && $creator->id == $c->id) ? 'selected' : '' }}>
                                            {{ $c->name }} ({{ $c->email }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="campaign_brief">Campaign Brief</label>
                                <textarea name="campaign_brief" id="campaign_brief" class="form-control" rows="5" required></textarea>
                                <small class="form-text text-muted">Describe your campaign in detail. PII will be automatically sanitized.</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="tone">Tone of Voice</label>
                                <input type="text" name="tone" id="tone" class="form-control" required>
                                <small class="form-text text-muted">e.g., Professional, Friendly, Humorous, etc.</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="budget_range">Budget Range</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="number" name="budget_range[0]" id="budget_min" class="form-control" placeholder="Minimum" required>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" name="budget_range[1]" id="budget_max" class="form-control" placeholder="Maximum" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="deliverables">Deliverables</label>
                                <div id="deliverables-container">
                                    <div class="input-group mb-2">
                                        <input type="text" name="deliverables[]" class="form-control" placeholder="Deliverable" required>
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-danger remove-deliverable" type="button">&times;</button>
                                        </div>
                                    </div>
                                </div>
                                <button type="button" id="add-deliverable" class="btn btn-outline-secondary btn-sm">Add Deliverable</button>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Generate Proposal</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add deliverable button
    document.getElementById('add-deliverable').addEventListener('click', function() {
        const container = document.getElementById('deliverables-container');
        const newInput = document.createElement('div');
        newInput.className = 'input-group mb-2';
        newInput.innerHTML = `
            <input type="text" name="deliverables[]" class="form-control" placeholder="Deliverable" required>
            <div class="input-group-append">
                <button class="btn btn-outline-danger remove-deliverable" type="button">&times;</button>
            </div>
        `;
        container.appendChild(newInput);
    });
    
    // Remove deliverable button
    document.getElementById('deliverables-container').addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-deliverable')) {
            e.target.closest('.input-group').remove();
        }
    });
    
    // Form submission
    document.getElementById('aiProposalForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        fetch('{{ route('brand.ai-proposals.store') }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message
                alert(data.message);
                // Redirect to show page
                window.location.href = '{{ url('brand/ai-proposals') }}/' + data.job_id;
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while generating the proposal.');
        });
    });
});
</script>
@endsection