@props(['collapsed' => false])

<div x-data="agencySidebar()" 
     x-init="init()"
     @keydown.window.ctrl.k.prevent="toggleQuickSearch()"
     class="agency-sidebar-wrapper">
    
    <!-- Sidebar -->
    <aside :class="{'collapsed': sidebarCollapsed}" 
           class="agency-sidebar fixed left-0 top-0 h-screen bg-gradient-to-b from-purple-900 to-indigo-900 text-white transition-all duration-300 z-50"
           :style="{'width': sidebarCollapsed ? '80px' : '280px'}">
        
        <!-- Logo & Toggle -->
        <div class="sidebar-header flex items-center justify-between p-4 border-b border-purple-700">
            <div class="flex items-center space-x-3" x-show="!sidebarCollapsed" x-transition>
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3zM6 8a2 2 0 11-4 0 2 2 0 014 0zM16 18v-3a5.972 5.972 0 00-.75-2.906A3.005 3.005 0 0119 15v3h-3zM4.75 12.094A5.973 5.973 0 004 15v3H1v-3a3 3 0 013.75-2.906z"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold">Agency Admin</h1>
                    <p class="text-xs text-purple-300">{{ auth()->user()->name ?? 'Dashboard' }}</p>
                </div>
            </div>
            <button @click="toggleSidebar()" 
                    class="p-2 rounded-lg hover:bg-purple-800 transition-colors focus:outline-none focus:ring-2 focus:ring-purple-500"
                    :aria-label="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'"
                    :title="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                          :d="sidebarCollapsed ? 'M13 5l7 7-7 7M5 5l7 7-7 7' : 'M11 19l-7-7 7-7m8 14l-7-7 7-7'"/>
                </svg>
            </button>
        </div>

        <!-- Quick Search -->
        <div class="p-4" x-show="!sidebarCollapsed" x-transition>
            <button @click="toggleQuickSearch()" 
                    class="w-full flex items-center space-x-2 px-3 py-2 bg-purple-800 rounded-lg hover:bg-purple-700 transition-colors focus:outline-none focus:ring-2 focus:ring-purple-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span class="text-sm text-purple-200">Quick Search</span>
                <span class="ml-auto text-xs text-purple-400">Ctrl+K</span>
            </button>
        </div>

        <!-- Navigation Menu -->
        <nav class="sidebar-nav flex-1 overflow-y-auto px-3 py-2 space-y-1" 
             role="navigation" 
             aria-label="Agency Admin Navigation">
            
            <!-- Dashboard -->
            <a href="{{ route('agency.dashboard') }}" 
               @click="setActive('dashboard')"
               :class="isActive('dashboard') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Dashboard' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Dashboard</span>
            </a>

            <!-- Managed Brands -->
            <a href="{{ route('agency.brands.index') }}" 
               @click="setActive('brands')"
               :class="isActive('brands') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Managed Brands' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Managed Brands</span>
                <span x-show="!sidebarCollapsed && badges.totalBrands > 0" 
                      class="ml-auto bg-purple-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.totalBrands"></span>
            </a>

            <!-- Campaigns -->
            <a href="{{ route('agency.campaigns.index') }}" 
               @click="setActive('campaigns')"
               :class="isActive('campaigns') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Campaigns' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Campaigns</span>
                <span x-show="!sidebarCollapsed && badges.activeCampaigns > 0" 
                      class="ml-auto bg-green-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.activeCampaigns"></span>
            </a>

            <!-- Proposals -->
            <a href="{{ route('agency.proposals.index') }}" 
               @click="setActive('proposals')"
               :class="isActive('proposals') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Proposals' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Proposals</span>
                <span x-show="!sidebarCollapsed && badges.pendingProposals > 0" 
                      class="ml-auto bg-yellow-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.pendingProposals"></span>
            </a>

            <!-- Creators -->
            <a href="{{ route('agency.creators.index') }}" 
               @click="setActive('creators')"
               :class="isActive('creators') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Creators' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Creators</span>
            </a>

            <!-- Messaging -->
            <a href="{{ route('agency.messages.index') }}" 
               @click="setActive('messages')"
               :class="isActive('messages') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Messaging' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Messaging</span>
                <span x-show="!sidebarCollapsed && badges.unreadMessages > 0" 
                      class="ml-auto bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.unreadMessages"></span>
            </a>

            <!-- Analytics & Reports -->
            <a href="{{ route('agency.analytics.index') }}" 
               @click="setActive('analytics')"
               :class="isActive('analytics') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Analytics & Reports' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Analytics & Reports</span>
            </a>

            <!-- Billing -->
            <a href="{{ route('agency.billing.index') }}" 
               @click="setActive('billing')"
               :class="isActive('billing') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Billing' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Billing</span>
            </a>

            <!-- Notifications -->
            <a href="#" 
               @click.prevent="toggleNotifications()"
               :class="showNotifications ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Notifications' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Notifications</span>
                <span x-show="!sidebarCollapsed && badges.notifications > 0" 
                      class="ml-auto bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.notifications"></span>
            </a>

            <!-- Support -->
            <a href="{{ route('agency.support.dashboard') }}" 
               @click="setActive('support')"
               :class="isActive('support') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Support' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Support</span>
            </a>

            <!-- Divider -->
            <div class="my-2 border-t border-purple-700"></div>

            <!-- Settings -->
            <div x-data="{ settingsOpen: false }">
                <button @click="settingsOpen = !settingsOpen"
                        :class="isActive('settings') ? 'bg-purple-600 text-white' : 'text-purple-200 hover:bg-purple-800'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Settings' : ''"
                        role="menuitem"
                        :aria-expanded="settingsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Settings</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="settingsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                
                <!-- Settings Submenu -->
                <div x-show="settingsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('agency.profile.edit') }}" 
                       class="block px-3 py-2 text-sm text-purple-300 hover:text-white hover:bg-purple-800 rounded-lg transition-colors">
                        Agency Profile
                    </a>
                    <a href="{{ route('agency.team.index') }}" 
                       class="block px-3 py-2 text-sm text-purple-300 hover:text-white hover:bg-purple-800 rounded-lg transition-colors">
                        Team Members
                    </a>
                    <a href="{{ route('agency.api-keys.index') }}" 
                       class="block px-3 py-2 text-sm text-purple-300 hover:text-white hover:bg-purple-800 rounded-lg transition-colors">
                        API Keys
                    </a>
                </div>
            </div>
        </nav>

        <!-- Account Menu -->
        <div class="sidebar-footer border-t border-purple-700 p-3">
            <div x-data="{ accountOpen: false }" class="relative">
                <button @click="accountOpen = !accountOpen"
                        class="w-full flex items-center space-x-3 px-3 py-2 rounded-lg hover:bg-purple-800 transition-colors focus:outline-none focus:ring-2 focus:ring-purple-500"
                        :aria-expanded="accountOpen">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-purple-400 to-pink-500 flex items-center justify-center text-sm font-bold flex-shrink-0">
                        {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
                    </div>
                    <div x-show="!sidebarCollapsed" class="flex-1 text-left">
                        <p class="text-sm font-medium text-white">{{ auth()->user()->name }}</p>
                        <p class="text-xs text-purple-300">Agency Admin</p>
                    </div>
                    <svg x-show="!sidebarCollapsed" 
                         :class="accountOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 text-purple-400 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>

                <!-- Account Dropdown -->
                <div x-show="accountOpen && !sidebarCollapsed" 
                     @click.away="accountOpen = false"
                     x-transition
                     class="absolute bottom-full left-0 right-0 mb-2 bg-purple-800 rounded-lg shadow-lg border border-purple-700 py-2">
                    <a href="{{ route('profile.edit') }}" 
                       class="block px-4 py-2 text-sm text-purple-200 hover:bg-purple-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Profile
                    </a>
                    <a href="#" 
                       @click.prevent="viewAuditLogs()"
                       class="block px-4 py-2 text-sm text-purple-200 hover:bg-purple-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Audit Logs
                    </a>
                    <div class="border-t border-purple-700 my-1"></div>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" 
                                class="w-full text-left px-4 py-2 text-sm text-red-400 hover:bg-purple-700 hover:text-red-300 transition-colors">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                            </svg>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </aside>

    <!-- Mobile Overlay -->
    <div x-show="mobileMenuOpen" 
         @click="mobileMenuOpen = false"
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden"
         aria-hidden="true"></div>

    <!-- Quick Search Modal -->
    <div x-show="quickSearchOpen" 
         @click.self="quickSearchOpen = false"
         @keydown.escape.window="quickSearchOpen = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-start justify-center pt-20"
         role="dialog"
         aria-modal="true"
         aria-labelledby="quick-search-title">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-2xl mx-4">
            <div class="p-4">
                <h2 id="quick-search-title" class="sr-only">Quick Search</h2>
                <input type="text" 
                       x-ref="quickSearchInput"
                       @input="filterSearch($event.target.value)"
                       placeholder="Search brands, campaigns, creators..."
                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                       autofocus>
            </div>
            <div class="max-h-96 overflow-y-auto border-t border-gray-200">
                <template x-for="result in searchResults" :key="result.name">
                    <a :href="result.url" 
                       class="block px-4 py-3 hover:bg-gray-50 transition-colors border-b border-gray-100">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900" x-text="result.name"></p>
                                <p class="text-xs text-gray-500" x-text="result.category"></p>
                            </div>
                        </div>
                    </a>
                </template>
                <div x-show="searchResults.length === 0" class="p-8 text-center text-gray-500">
                    <svg class="w-12 h-12 mx-auto mb-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <p>No results found</p>
                </div>
            </div>
        </div>
    <!-- Confirmation Modal -->
    <div x-show="confirmModal.show" 
         @click.self="confirmModal.show = false"
         @keydown.escape.window="confirmModal.show = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center"
         role="dialog"
         aria-modal="true">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-md mx-4 p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="w-12 h-12 rounded-full flex items-center justify-center"
                     :class="confirmModal.type === 'danger' ? 'bg-red-100' : 'bg-yellow-100'">
                    <svg class="w-6 h-6" 
                         :class="confirmModal.type === 'danger' ? 'text-red-600' : 'text-yellow-600'"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-gray-900" x-text="confirmModal.title"></h3>
                </div>
            </div>
            <p class="text-sm text-gray-600 mb-6" x-text="confirmModal.message"></p>
            <div class="flex space-x-3">
                <button @click="confirmModal.show = false"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-purple-500">
                    Cancel
                </button>
                <button @click="confirmAction()"
                        class="flex-1 px-4 py-2 rounded-lg text-white transition-colors focus:outline-none focus:ring-2"
                        :class="confirmModal.type === 'danger' ? 'bg-red-600 hover:bg-red-700 focus:ring-red-500' : 'bg-yellow-600 hover:bg-yellow-700 focus:ring-yellow-500'">
                    Confirm
                </button>
            </div>
        </div>
    </div>

    </div>

    <!-- Mobile Menu Button -->
    <button @click="mobileMenuOpen = !mobileMenuOpen"
            class="lg:hidden fixed top-4 left-4 z-50 p-2 bg-purple-900 text-white rounded-lg shadow-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
            aria-label="Toggle mobile menu">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
        </svg>
    </button>
</div>

<script>
function agencySidebar() {
    return {
        sidebarCollapsed: localStorage.getItem('agencySidebarCollapsed') === 'true',
        mobileMenuOpen: false,
        quickSearchOpen: false,
        showNotifications: false,
        activeItem: '',
        badges: {
            totalBrands: 0,
            pendingProposals: 0,
            activeCampaigns: 0,
            unreadMessages: 0,
            notifications: 0
        },
        searchResults: [],
        confirmModal: {
            show: false,
            title: '',
            message: '',
            type: 'warning',
            callback: null
        },
        allNavItems: [
            { name: 'Dashboard', url: '{{ route("agency.dashboard") }}', category: 'Navigation' },
            { name: 'Managed Brands', url: '{{ route("agency.brands.index") }}', category: 'Navigation' },
            { name: 'Campaigns', url: '{{ route("agency.campaigns.index") }}', category: 'Navigation' },
            { name: 'Proposals', url: '{{ route("agency.proposals.index") }}', category: 'Navigation' },
            { name: 'Creators', url: '{{ route("agency.creators.index") }}', category: 'Navigation' },
            { name: 'Messaging', url: '{{ route("agency.messages.index") }}', category: 'Navigation' },
            { name: 'Analytics & Reports', url: '{{ route("agency.analytics.index") }}', category: 'Navigation' },
            { name: 'Billing', url: '{{ route("agency.billing.index") }}', category: 'Navigation' },
            { name: 'Support', url: '{{ route("agency.support.dashboard") }}', category: 'Navigation' }
        ],

        init() {
            this.setActiveFromUrl();
            this.loadBadges();
            this.setupKeyboardNavigation();
            this.setupConfirmationHandlers();
            
            // Refresh badges every 30 seconds
            setInterval(() => this.loadBadges(), 30000);
        },

        toggleSidebar() {
            this.sidebarCollapsed = !this.sidebarCollapsed;
            localStorage.setItem('agencySidebarCollapsed', this.sidebarCollapsed);
        },

        toggleQuickSearch() {
            this.quickSearchOpen = !this.quickSearchOpen;
            if (this.quickSearchOpen) {
                this.$nextTick(() => {
                    this.$refs.quickSearchInput?.focus();
                });
            }
        },

        toggleNotifications() {
            this.showNotifications = !this.showNotifications;
            // TODO: Implement notifications panel
        },

        setActive(item) {
            this.activeItem = item;
            localStorage.setItem('activeAgencyNavItem', item);
        },

        isActive(item) {
            return this.activeItem === item;
        },

        setActiveFromUrl() {
            const path = window.location.pathname;
            if (path.includes('/dashboard')) this.activeItem = 'dashboard';
            else if (path.includes('/brands')) this.activeItem = 'brands';
            else if (path.includes('/campaigns')) this.activeItem = 'campaigns';
            else if (path.includes('/proposals')) this.activeItem = 'proposals';
            else if (path.includes('/creators')) this.activeItem = 'creators';
            else if (path.includes('/messages')) this.activeItem = 'messages';
            else if (path.includes('/analytics')) this.activeItem = 'analytics';
            else if (path.includes('/billing')) this.activeItem = 'billing';
            else if (path.includes('/support')) this.activeItem = 'support';
            else if (path.includes('/settings') || path.includes('/profile') || path.includes('/team') || path.includes('/api-keys')) this.activeItem = 'settings';
        },

        async loadBadges() {
            try {
                const response = await fetch('{{ route("agency.sidebar.badges") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        this.badges = data.badges;
                    }
                }
            } catch (error) {
                console.error('Failed to load badges:', error);
            }
        },

        async filterSearch(query) {
            if (!query.trim()) {
                this.searchResults = [];
                return;
            }

            const lowerQuery = query.toLowerCase();
            
            // Filter local nav items
            const navResults = this.allNavItems.filter(item => 
                item.name.toLowerCase().includes(lowerQuery) ||
                item.category.toLowerCase().includes(lowerQuery)
            );

            // Fetch API results
            try {
                const response = await fetch(`{{ route("agency.sidebar.search") }}?query=${encodeURIComponent(query)}`, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        this.searchResults = [...navResults, ...data.results];
                        return;
                    }
                }
            } catch (error) {
                console.error('Search failed:', error);
            }
            
            this.searchResults = navResults;
        },

        setupKeyboardNavigation() {
            document.addEventListener('keydown', (e) => {
                // Ctrl/Cmd + K for quick search
                if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
                    e.preventDefault();
                    this.toggleQuickSearch();
                }
                
                // Escape to close modals
                if (e.key === 'Escape') {
                    this.quickSearchOpen = false;
                    this.showNotifications = false;
                }
            });
        },

        viewAuditLogs() {
            window.location.href = '{{ route("agency.audit-logs.index") }}';
        },

        showConfirmation(title, message, type, callback) {
            this.confirmModal = {
                show: true,
                title,
                message,
                type,
                callback
            };
        },

        confirmAction() {
            if (this.confirmModal.callback) {
                this.confirmModal.callback();
            }
            this.confirmModal.show = false;
        },

        setupConfirmationHandlers() {
            // Listen for confirmation requests on elements with data-confirm attribute
            document.addEventListener('click', (e) => {
                const target = e.target.closest('[data-confirm]');
                if (target) {
                    e.preventDefault();
                    this.showConfirmation(
                        target.dataset.confirmTitle || 'Confirm Action',
                        target.dataset.confirm,
                        target.dataset.confirmType || 'warning',
                        () => {
                            if (target.tagName === 'A') {
                                window.location.href = target.href;
                            } else if (target.tagName === 'BUTTON') {
                                target.form?.submit();
                            }
                        }
                    );
                }
            });
        }
    };
}
</script>

<style>
.agency-sidebar-wrapper {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
}

.agency-sidebar {
    display: flex;
    flex-direction: column;
}

.sidebar-nav {
    scrollbar-width: thin;
    scrollbar-color: rgba(255, 255, 255, 0.2) transparent;
}

.sidebar-nav::-webkit-scrollbar {
    width: 6px;
}

.sidebar-nav::-webkit-scrollbar-track {
    background: transparent;
}

.sidebar-nav::-webkit-scrollbar-thumb {
    background-color: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar-nav::-webkit-scrollbar-thumb:hover {
    background-color: rgba(255, 255, 255, 0.3);
}

.nav-item {
    position: relative;
}

.nav-item:focus {
    outline: 2px solid #a855f7;
    outline-offset: 2px;
}

@media (max-width: 1024px) {
    .agency-sidebar {
        transform: translateX(-100%);
    }
    
    .agency-sidebar-wrapper[x-data] .agency-sidebar {
        transform: translateX(0);
    }
}

/* Smooth transitions */
* {
    transition-property: background-color, border-color, color, fill, stroke, opacity, box-shadow, transform;
    transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    transition-duration: 150ms;
}
</style>