@extends('adminlte::page')

@section('title', 'Content Details')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">{{ $content->title }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.content.index') }}">Content</a></li>
                    <li class="breadcrumb-item active">Details</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Content Details</h3>
                        <div class="card-tools">
                            <a href="{{ route('creator.content.edit', $content) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="{{ route('creator.content.destroy', $content) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this content?')">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Title</label>
                                    <p>{{ $content->title }}</p>
                                </div>
                                
                                <div class="form-group">
                                    <label>Status</label>
                                    <p>
                                        <span class="badge 
                                            @if($content->status === 'draft') badge-warning
                                            @elseif($content->status === 'pending') badge-info
                                            @elseif($content->status === 'published') badge-success
                                            @endif">
                                            {{ ucfirst($content->status) }}
                                        </span>
                                    </p>
                                </div>
                                
                                <div class="form-group">
                                    <label>Content</label>
                                    <div class="border p-3 rounded">
                                        {!! nl2br(e($content->body)) !!}
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Created At</label>
                                    <p>{{ $content->created_at->format('M d, Y H:i') }}</p>
                                </div>
                                
                                <div class="form-group">
                                    <label>Updated At</label>
                                    <p>{{ $content->updated_at->format('M d, Y H:i') }}</p>
                                </div>
                                
                                <div class="form-group">
                                    <label>Metrics</label>
                                    <div class="border p-3 rounded">
                                        <p>Views: <span class="badge badge-primary">0</span></p>
                                        <p>Likes: <span class="badge badge-success">0</span></p>
                                        <p>Shares: <span class="badge badge-info">0</span></p>
                                        <p>Comments: <span class="badge badge-warning">0</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="form-group">
                                    <label>Raw Data</label>
                                    <pre class="bg-light p-3 rounded">{{ json_encode($content->toArray(), JSON_PRETTY_PRINT) }}</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection