@extends('adminlte::page')

@section('title', 'Create Proposal')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Create Proposal</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.proposals.index') }}">Proposals</a></li>
                    <li class="breadcrumb-item active">Create</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">New Proposal</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('creator.proposals.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            @if($campaign)
                            <div class="form-group">
                                <label for="campaign">Campaign</label>
                                <input type="text" class="form-control" id="campaign" value="{{ $campaign->name }}" disabled>
                                <input type="hidden" name="campaign_id" value="{{ $campaign->id }}">
                                <small class="form-text text-muted">This proposal is for the campaign: {{ $campaign->name }}</small>
                            </div>
                            @endif
                            
                            <div class="form-group">
                                <label for="brand_id">Brand</label>
                                <select name="brand_id" id="brand_id" class="form-control select2" required>
                                    <option value="">Select a brand</option>
                                    @foreach(\App\Models\Brand::all() as $brand)
                                        <option value="{{ $brand->id }}" {{ old('brand_id') == $brand->id ? 'selected' : '' }}>
                                            {{ $brand->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('brand_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control" value="{{ old('title') }}" required>
                                @error('title')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="message">Message</label>
                                <textarea name="message" id="message" class="form-control" rows="5" required>{{ old('message') }}</textarea>
                                @error('message')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="type">Type</label>
                                <select name="type" id="type" class="form-control" required>
                                    <option value="">Select a type</option>
                                    <option value="Collaboration" {{ old('type') == 'Collaboration' ? 'selected' : '' }}>Collaboration</option>
                                    <option value="Sponsored Post" {{ old('type') == 'Sponsored Post' ? 'selected' : '' }}>Sponsored Post</option>
                                    <option value="Affiliate" {{ old('type') == 'Affiliate' ? 'selected' : '' }}>Affiliate</option>
                                    <option value="Long-term Partnership" {{ old('type') == 'Long-term Partnership' ? 'selected' : '' }}>Long-term Partnership</option>
                                </select>
                                @error('type')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="budget">Budget (USD)</label>
                                <input type="number" name="budget" id="budget" class="form-control" value="{{ old('budget') }}" step="0.01" min="0">
                                @error('budget')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="duration">Duration</label>
                                <input type="text" name="duration" id="duration" class="form-control" value="{{ old('duration') }}">
                                @error('duration')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="deliverables">Deliverables</label>
                                <textarea name="deliverables" id="deliverables" class="form-control" rows="3">{{ old('deliverables') }}</textarea>
                                <small class="form-text text-muted">Enter one deliverable per line</small>
                                @error('deliverables')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <div class="custom-file">
                                    <input type="file" name="attachment" id="attachment" class="custom-file-input">
                                    <label class="custom-file-label" for="attachment">Choose file</label>
                                </div>
                                <small class="form-text text-muted">PDF, DOC, DOCX up to 2MB</small>
                                @error('attachment')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i> Send Proposal
                                </button>
                                <a href="{{ route('creator.proposals.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2
    if ($.fn.select2) {
        $('#brand_id').select2({
            placeholder: 'Select a brand',
            allowClear: true
        });
    }
    
    // Update file label when file is selected
    $('.custom-file-input').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
});
</script>
@endsection