@extends('adminlte::page')

@section('title', 'Edit Scheduled Post')

@section('content_header')
    <h1>Edit Scheduled Post</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Post Details</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('creator.scheduled-posts.update', $scheduledPost) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="form-group">
                        <label for="social_account_id">Social Account</label>
                        <select name="social_account_id" id="social_account_id" class="form-control" required>
                            <option value="">Select a social account</option>
                            @foreach($socialAccounts as $account)
                                <option value="{{ $account->id }}" {{ (old('social_account_id', $scheduledPost->social_account_id) == $account->id) ? 'selected' : '' }}>
                                    {{ ucfirst($account->provider) }} ({{ $account->meta['username'] ?? 'N/A' }})
                                </option>
                            @endforeach
                        </select>
                        @error('social_account_id')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="caption">Caption</label>
                        <textarea name="caption" id="caption" class="form-control" rows="4" placeholder="Enter your post caption">{{ old('caption', $scheduledPost->caption) }}</textarea>
                        <small class="form-text text-muted">Maximum 2200 characters</small>
                        @error('caption')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="media_refs">Media URLs (Optional)</label>
                        <div id="media-refs-container">
                            @if(old('media_refs') || $scheduledPost->media_refs)
                                @php
                                    $mediaRefs = old('media_refs', $scheduledPost->media_refs);
                                @endphp
                                @foreach($mediaRefs as $index => $mediaRef)
                                    <div class="media-ref-input mb-2">
                                        <div class="input-group">
                                            <input type="text" name="media_refs[{{ $index }}][url]" class="form-control" placeholder="Media URL" value="{{ old('media_refs.' . $index . '.url', $mediaRef['url'] ?? '') }}">
                                            <select name="media_refs[{{ $index }}][type]" class="form-control" style="max-width: 150px;">
                                                <option value="image" {{ old('media_refs.' . $index . '.type', $mediaRef['type'] ?? 'image') == 'image' ? 'selected' : '' }}>Image</option>
                                                <option value="video" {{ old('media_refs.' . $index . '.type', $mediaRef['type'] ?? '') == 'video' ? 'selected' : '' }}>Video</option>
                                            </select>
                                            <div class="input-group-append">
                                                <button type="button" class="btn btn-danger remove-media-ref">Remove</button>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="media-ref-input mb-2">
                                    <div class="input-group">
                                        <input type="text" name="media_refs[0][url]" class="form-control" placeholder="Media URL">
                                        <select name="media_refs[0][type]" class="form-control" style="max-width: 150px;">
                                            <option value="image">Image</option>
                                            <option value="video">Video</option>
                                        </select>
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger remove-media-ref">Remove</button>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <button type="button" id="add-media-ref" class="btn btn-secondary mt-2">Add Media</button>
                        @error('media_refs')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="publish_time">Publish Time</label>
                        <input type="datetime-local" name="publish_time" id="publish_time" class="form-control" value="{{ old('publish_time', $scheduledPost->publish_time ? $scheduledPost->publish_time->format('Y-m-d\TH:i') : '') }}" required>
                        @error('publish_time')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="timezone">Timezone</label>
                        <select name="timezone" id="timezone" class="form-control" required>
                            <option value="">Select timezone</option>
                            @foreach(timezone_identifiers_list() as $tz)
                                <option value="{{ $tz }}" {{ old('timezone', $scheduledPost->timezone ?? 'Asia/Calcutta') == $tz ? 'selected' : '' }}>
                                    {{ $tz }}
                                </option>
                            @endforeach
                        </select>
                        @error('timezone')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="campaign_id">Campaign (Optional)</label>
                        <select name="campaign_id" id="campaign_id" class="form-control">
                            <option value="">No campaign</option>
                            @foreach($campaigns as $campaign)
                                <option value="{{ $campaign->id }}" {{ old('campaign_id', $scheduledPost->campaign_id) == $campaign->id ? 'selected' : '' }}>
                                    {{ $campaign->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('campaign_id')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="post_visibility">Visibility</label>
                        <select name="post_visibility" id="post_visibility" class="form-control" required>
                            <option value="public" {{ old('post_visibility', $scheduledPost->post_visibility) == 'public' ? 'selected' : '' }}>Public</option>
                            <option value="draft" {{ old('post_visibility', $scheduledPost->post_visibility) == 'draft' ? 'selected' : '' }}>Draft</option>
                        </select>
                        @error('post_visibility')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="recurrence">Recurrence (Optional)</label>
                        <select name="recurrence[type]" id="recurrence" class="form-control">
                            <option value="">No recurrence</option>
                            <option value="daily" {{ old('recurrence.type', $scheduledPost->recurrence['type'] ?? '') == 'daily' ? 'selected' : '' }}>Daily</option>
                            <option value="weekly" {{ old('recurrence.type', $scheduledPost->recurrence['type'] ?? '') == 'weekly' ? 'selected' : '' }}>Weekly</option>
                            <option value="monthly" {{ old('recurrence.type', $scheduledPost->recurrence['type'] ?? '') == 'monthly' ? 'selected' : '' }}>Monthly</option>
                        </select>
                        <small class="form-text text-muted">Set this post to repeat on a schedule.</small>
                        @error('recurrence')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input type="checkbox" name="auto_reply_enabled" id="auto_reply_enabled" class="form-check-input" {{ old('auto_reply_enabled', $scheduledPost->auto_reply_enabled) ? 'checked' : '' }}>
                            <label for="auto_reply_enabled" class="form-check-label">Enable Auto-Reply</label>
                        </div>
                        <small class="form-text text-muted">If checked, auto-replies will be enabled for comments on this post.</small>
                        @error('auto_reply_enabled')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group" id="auto-reply-template-group" style="{{ old('auto_reply_enabled', $scheduledPost->auto_reply_enabled) ? '' : 'display: none;' }}">
                        <label for="auto_reply_template">Auto-Reply Template</label>
                        <textarea name="auto_reply_template" id="auto_reply_template" class="form-control" rows="3" placeholder="Enter your auto-reply template">{{ old('auto_reply_template', $scheduledPost->auto_reply_template) }}</textarea>
                        <small class="form-text text-muted">Enter a template for auto-replies to comments on this post. You can use placeholders like {username} for the commenter's username.</small>
                        @error('auto_reply_template')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Update Post</button>
                    <a href="{{ route('creator.scheduled-posts.show', $scheduledPost) }}" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add media ref button
        document.getElementById('add-media-ref').addEventListener('click', function() {
            const container = document.getElementById('media-refs-container');
            const index = container.children.length;
            
            const div = document.createElement('div');
            div.className = 'media-ref-input mb-2';
            div.innerHTML = `
                <div class="input-group">
                    <input type="text" name="media_refs[${index}][url]" class="form-control" placeholder="Media URL">
                    <select name="media_refs[${index}][type]" class="form-control" style="max-width: 150px;">
                        <option value="image">Image</option>
                        <option value="video">Video</option>
                    </select>
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-media-ref">Remove</button>
                    </div>
                </div>
            `;
            
            container.appendChild(div);
        });
        
        // Remove media ref button
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-media-ref')) {
                e.target.closest('.media-ref-input').remove();
            }
        });
        
        // Toggle auto-reply template field
        document.getElementById('auto_reply_enabled').addEventListener('change', function() {
            const templateGroup = document.getElementById('auto-reply-template-group');
            if (this.checked) {
                templateGroup.style.display = 'block';
            } else {
                templateGroup.style.display = 'none';
            }
        });
    });
</script>
@stop