@extends('adminlte::page')

@section('title', 'Scheduled Post Details')

@section('content_header')
    <h1>Scheduled Post Details</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Post #{{ $scheduledPost->id }}</h3>
                <div class="card-tools">
                    @if(in_array($scheduledPost->status, ['scheduled', 'draft']))
                        <form action="{{ route('creator.scheduled-posts.publish-now', $scheduledPost) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-bolt"></i> Publish Now
                            </button>
                        </form>
                    @endif
                    
                    @if(in_array($scheduledPost->status, ['scheduled', 'draft']))
                        <a href="{{ route('creator.scheduled-posts.edit', $scheduledPost) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                    @endif
                    
                    @if(in_array($scheduledPost->status, ['scheduled', 'draft']))
                        <form action="{{ route('creator.scheduled-posts.cancel', $scheduledPost) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to cancel this scheduled post?')">
                                <i class="fas fa-times"></i> Cancel
                            </button>
                        </form>
                    @endif
                    
                    @if($scheduledPost->status === 'failed')
                        <form action="{{ route('creator.scheduled-posts.retry', $scheduledPost) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-redo"></i> Retry
                            </button>
                        </form>
                    @endif
                    
                    @if(in_array($scheduledPost->status, ['scheduled', 'draft', 'posted']))
                        <form action="{{ route('creator.scheduled-posts.duplicate', $scheduledPost) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-secondary">
                                <i class="fas fa-copy"></i> Duplicate
                            </button>
                        </form>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h4>Post Information</h4>
                        <table class="table table-bordered">
                            <tr>
                                <th>Social Account</th>
                                <td>{{ $scheduledPost->socialAccount->provider ?? 'N/A' }} ({{ $scheduledPost->socialAccount->meta['username'] ?? 'N/A' }})</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($scheduledPost->status === 'draft')
                                        <span class="badge badge-secondary">Draft</span>
                                    @elseif($scheduledPost->status === 'scheduled')
                                        <span class="badge badge-info">Scheduled</span>
                                    @elseif($scheduledPost->status === 'publishing')
                                        <span class="badge badge-primary">Publishing</span>
                                    @elseif($scheduledPost->status === 'posted')
                                        <span class="badge badge-success">Posted</span>
                                    @elseif($scheduledPost->status === 'failed')
                                        <span class="badge badge-danger">Failed</span>
                                    @elseif($scheduledPost->status === 'cancelled')
                                        <span class="badge badge-dark">Cancelled</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Publish Time</th>
                                <td>{{ $scheduledPost->publish_time ? $scheduledPost->publish_time->format('Y-m-d H:i') : 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Timezone</th>
                                <td>{{ $scheduledPost->timezone ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Visibility</th>
                                <td>{{ ucfirst($scheduledPost->post_visibility) }}</td>
                            </tr>
                            <tr>
                                <th>Campaign</th>
                                <td>{{ $scheduledPost->campaign->name ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Auto-Reply Enabled</th>
                                <td>{{ $scheduledPost->auto_reply_enabled ? 'Yes' : 'No' }}</td>
                            </tr>
                            <tr>
                                <th>Auto-Reply Template</th>
                                <td>{{ $scheduledPost->auto_reply_template ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td>{{ $scheduledPost->created_at->format('Y-m-d H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Remote Post ID</th>
                                <td>{{ $scheduledPost->remote_post_id ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Attempt Count</th>
                                <td>{{ $scheduledPost->attempt_count }}</td>
                            </tr>
                        </table>
                    </div>
                    
                    <div class="col-md-6">
                        <h4>Content</h4>
                        <div class="form-group">
                            <label>Caption</label>
                            <div class="border p-3 bg-light">
                                {{ $scheduledPost->caption ?? 'N/A' }}
                            </div>
                        </div>
                        
                        @if($scheduledPost->media_refs && count($scheduledPost->media_refs) > 0)
                            <div class="form-group">
                                <label>Media</label>
                                <div>
                                    @foreach($scheduledPost->media_refs as $media)
                                        <div class="mb-2">
                                            <strong>Type:</strong> {{ $media['type'] ?? 'N/A' }}<br>
                                            <strong>URL:</strong> {{ $media['url'] ?? 'N/A' }}
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                
                @if($scheduledPost->error_message)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h4>Error Information</h4>
                            <div class="alert alert-danger">
                                {{ $scheduledPost->error_message }}
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@stop