@extends('adminlte::page')

@section('title', 'Account Settings')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Account Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.settings.account') }}">Settings</a></li>
                    <li class="breadcrumb-item active">Account</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Change Password</h3>
                    </div>
                    <div class="card-body">
                        <form>
                            <div class="form-group">
                                <label for="current_password">Current Password</label>
                                <input type="password" class="form-control" id="current_password" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="new_password">New Password</label>
                                <input type="password" class="form-control" id="new_password" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="confirm_password">Confirm New Password</label>
                                <input type="password" class="form-control" id="confirm_password" required>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Update Password</button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Privacy Settings</h3>
                    </div>
                    <div class="card-body">
                        <form>
                            <div class="form-group">
                                <label>Profile Visibility</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="profile_visibility" id="visibility_public" checked>
                                    <label class="form-check-label" for="visibility_public">
                                        Public
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="profile_visibility" id="visibility_private">
                                    <label class="form-check-label" for="visibility_private">
                                        Private
                                    </label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Show Email</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="show_email" checked>
                                    <label class="form-check-label" for="show_email">
                                        Display email on profile
                                    </label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Show Social Links</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="show_social_links" checked>
                                    <label class="form-check-label" for="show_social_links">
                                        Display social media links
                                    </label>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Save Privacy Settings</button>
                        </form>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Delete Account</h3>
                    </div>
                    <div class="card-body">
                        <p>Once you delete your account, there is no going back. Please be certain.</p>
                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteAccountModal">
                            Delete Account
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Account Modal -->
<div class="modal fade" id="deleteAccountModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Account</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete your account? This action cannot be undone.</p>
                <p>All your data will be permanently removed from our system.</p>
                <div class="form-group">
                    <label for="delete_password">Enter your password to confirm</label>
                    <input type="password" class="form-control" id="delete_password" placeholder="Password">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger">Delete Account</button>
            </div>
        </div>
    </div>
</div>
@endsection