@extends('adminlte::page')

@section('title', 'Social Settings')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Social Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.settings.social') }}">Settings</a></li>
                    <li class="breadcrumb-item active">Social</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Notification & Sync Preferences</h3>
                    </div>
                    <div class="card-body">
                        <p>Configure your social media notification and synchronization preferences.</p>
                        
                        <form>
                            <div class="form-group">
                                <label for="sync_frequency">Sync Frequency</label>
                                <select class="form-control" id="sync_frequency">
                                    <option>Every 15 minutes</option>
                                    <option>Every 30 minutes</option>
                                    <option>Every hour</option>
                                    <option>Every 6 hours</option>
                                    <option>Daily</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="notification_email">Notification Email</label>
                                <input type="email" class="form-control" id="notification_email" placeholder="Enter email for notifications">
                            </div>
                            
                            <div class="form-group">
                                <label>Notification Preferences</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="notify_new_followers">
                                    <label class="form-check-label" for="notify_new_followers">
                                        Notify on new followers
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="notify_comments">
                                    <label class="form-check-label" for="notify_comments">
                                        Notify on new comments
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="notify_likes">
                                    <label class="form-check-label" for="notify_likes">
                                        Notify on new likes
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="notify_mentions">
                                    <label class="form-check-label" for="notify_mentions">
                                        Notify on mentions
                                    </label>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Save Settings</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection