@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Social Connections</h2>
                    <p class="text-muted">Manage your social media accounts and share access with brands</p>
                </div>
                <a href="{{ route('creator.social-connections.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Connect New Account
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($connections->isEmpty())
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-link fa-4x text-muted mb-3"></i>
                <h4>No Social Connections Yet</h4>
                <p class="text-muted mb-4">Connect your social media accounts to start sharing with brands</p>
                <a href="{{ route('creator.social-connections.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Connect Your First Account
                </a>
            </div>
        </div>
    @else
        <div class="row">
            @foreach($connections as $connection)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex align-items-center">
                                    <div class="platform-icon me-3">
                                        <i class="{{ $connection->platform_icon }} fa-2x" style="color: {{ $connection->platform === 'instagram' ? '#E4405F' : ($connection->platform === 'youtube' ? '#FF0000' : ($connection->platform === 'twitter' ? '#000000' : ($connection->platform === 'tiktok' ? '#000000' : ($connection->platform === 'linkedin' ? '#0077B5' : '#1877F2')))) }}"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">{{ $connection->platform_display_name }}</h5>
                                        @if($connection->platform_username)
                                            <small class="text-muted">@{{ $connection->platform_username }}</small>
                                        @endif
                                    </div>
                                </div>
                                <span class="badge bg-{{ $connection->status_color }}">
                                    {{ ucfirst($connection->status) }}
                                </span>
                            </div>

                            @if($connection->label)
                                <p class="text-muted mb-2">
                                    <i class="fas fa-tag me-1"></i>{{ $connection->label }}
                                </p>
                            @endif

                            @if($connection->platform_display_name)
                                <p class="mb-2">
                                    <strong>{{ $connection->platform_display_name }}</strong>
                                </p>
                            @endif

                            @if($connection->last_tested_at)
                                <p class="text-muted small mb-2">
                                    <i class="fas fa-clock me-1"></i>Last tested: {{ $connection->last_tested_at->diffForHumans() }}
                                </p>
                            @endif

                            @if($connection->isExpiringSoon())
                                <div class="alert alert-warning py-2 px-3 mb-3">
                                    <i class="fas fa-exclamation-triangle me-1"></i>
                                    <small>Token expires {{ $connection->token_expires_at->diffForHumans() }}</small>
                                </div>
                            @endif

                            @if($connection->use_for_ads)
                                <div class="badge bg-info mb-3">
                                    <i class="fas fa-ad me-1"></i>Ad Access Enabled
                                </div>
                            @endif

                            <!-- Shared Access Info -->
                            @if($connection->activeSharedAccess->count() > 0)
                                <div class="border-top pt-3 mb-3">
                                    <h6 class="text-muted mb-2">
                                        <i class="fas fa-share-alt me-1"></i>Shared With:
                                    </h6>
                                    @foreach($connection->activeSharedAccess as $shared)
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <div>
                                                <small class="fw-bold">{{ $shared->brand->name }}</small>
                                                <br>
                                                <small class="text-muted">Expires: {{ $shared->expires_at->format('M d, Y') }}</small>
                                            </div>
                                            <span class="badge bg-{{ $shared->status_color }}">{{ $shared->access_level_display }}</span>
                                        </div>
                                    @endforeach>
                                </div>
                            @endif

                            <!-- Actions -->
                            <div class="d-flex gap-2 flex-wrap">
                                <a href="{{ route('creator.social-connections.show', $connection) }}" class="btn btn-sm btn-outline-primary flex-fill">
                                    <i class="fas fa-eye me-1"></i>View
                                </a>
                                <button type="button" class="btn btn-sm btn-outline-success flex-fill" onclick="testConnection({{ $connection->id }})">
                                    <i class="fas fa-check me-1"></i>Test
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger flex-fill" onclick="deleteConnection({{ $connection->id }})">
                                    <i class="fas fa-trash me-1"></i>Delete
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <!-- Available Platforms Info -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-info-circle me-2"></i>Available Platforms
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                @foreach($platforms as $platform)
                    <div class="col-md-4 mb-3">
                        <div class="d-flex align-items-center">
                            <i class="{{ $platform['icon'] }} fa-2x me-3" style="color: {{ $platform['color'] }}"></i>
                            <div>
                                <strong>{{ $platform['name'] }}</strong>
                                <br>
                                <small class="text-muted">{{ $platform['description'] }}</small>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this connection?</p>
                <p class="text-danger"><strong>Warning:</strong> This will revoke all shared access with brands.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Connection</button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function testConnection(connectionId) {
    const btn = event.target.closest('button');
    const originalHtml = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Testing...';

    fetch(`/creator/social-connections/${connectionId}/test`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Connection test successful!');
            location.reload();
        } else {
            alert('Connection test failed: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error testing connection: ' + error.message);
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = originalHtml;
    });
}

function deleteConnection(connectionId) {
    const form = document.getElementById('deleteForm');
    form.action = `/creator/social-connections/${connectionId}`;
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}
</script>
@endpush
@endsection