@extends('layouts.marketing')

@section('title', 'Help Center - AI Business Market')
@section('description', 'Find answers to your questions. Browse our documentation, guides, and FAQs to get the most out of AI Business Market.')

@push('structured-data')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
        {
            "@type": "Question",
            "name": "How do I get started with AI Business Market?",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "Getting started is easy! Sign up for a free 14-day trial, connect your social accounts, and start creating campaigns. No credit card required."
            }
        },
        {
            "@type": "Question",
            "name": "What social platforms do you support?",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "We support Instagram, Facebook, Twitter, LinkedIn, TikTok, and YouTube. More platforms are being added regularly."
            }
        },
        {
            "@type": "Question",
            "name": "Can I cancel my subscription anytime?",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "Yes, you can cancel your subscription at any time. You'll continue to have access until the end of your billing period."
            }
        }
    ]
}
</script>
@endpush

@section('content')
<div x-data="{ searchQuery: '', selectedCategory: 'all' }">
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-20">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                How Can We Help You?
            </h1>
            <p class="text-xl text-gray-600 mb-8">
                Search our knowledge base or browse categories below
            </p>
            
            <!-- Search Bar -->
            <div class="relative max-w-2xl mx-auto">
                <input type="text"
                       x-model="searchQuery"
                       placeholder="Search for help articles, guides, tutorials..."
                       class="w-full px-6 py-4 pl-14 text-lg border-2 border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent shadow-lg">
                <div class="absolute left-5 top-1/2 transform -translate-y-1/2 text-gray-400">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                </div>
            </div>
        </div>
    </section>

    <!-- Quick Links -->
    <section class="py-12 bg-white border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-4 gap-6">
                <a href="#getting-started" class="group p-6 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl hover:shadow-lg transition duration-200">
                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">Getting Started</h3>
                    <p class="text-sm text-gray-600">Quick start guides and tutorials</p>
                </a>

                <a href="#features" class="group p-6 bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl hover:shadow-lg transition duration-200">
                    <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">Features</h3>
                    <p class="text-sm text-gray-600">Learn about platform features</p>
                </a>

                <a href="#billing" class="group p-6 bg-gradient-to-br from-green-50 to-green-100 rounded-xl hover:shadow-lg transition duration-200">
                    <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">Billing & Plans</h3>
                    <p class="text-sm text-gray-600">Subscription and payment help</p>
                </a>

                <a href="#troubleshooting" class="group p-6 bg-gradient-to-br from-yellow-50 to-yellow-100 rounded-xl hover:shadow-lg transition duration-200">
                    <div class="w-12 h-12 bg-yellow-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">Troubleshooting</h3>
                    <p class="text-sm text-gray-600">Common issues and solutions</p>
                </a>
            </div>
        </div>
    </section>

    <!-- Popular Articles -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-gray-900 mb-8">Popular Articles</h2>
            
            @php
            $articles = [
                ['title' => 'How to Connect Your Social Accounts', 'category' => 'Getting Started', 'views' => '12.5K', 'icon' => 'link'],
                ['title' => 'Creating Your First Campaign', 'category' => 'Campaigns', 'views' => '10.2K', 'icon' => 'flag'],
                ['title' => 'Using AI to Generate Proposals', 'category' => 'AI Tools', 'views' => '9.8K', 'icon' => 'sparkles'],
                ['title' => 'Understanding Analytics Dashboard', 'category' => 'Analytics', 'views' => '8.5K', 'icon' => 'chart'],
                ['title' => 'Managing Team Members', 'category' => 'Account', 'views' => '7.3K', 'icon' => 'users'],
                ['title' => 'Scheduling Posts Across Platforms', 'category' => 'Content', 'views' => '6.9K', 'icon' => 'calendar']
            ];
            @endphp
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($articles as $article)
                <a href="#" class="block bg-white rounded-xl p-6 hover:shadow-lg transition duration-200 border border-gray-200">
                    <div class="flex items-start justify-between mb-3">
                        <span class="inline-block px-3 py-1 bg-blue-100 text-blue-800 text-xs font-semibold rounded-full">
                            {{ $article['category'] }}
                        </span>
                        <span class="text-xs text-gray-500">{{ $article['views'] }} views</span>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2 hover:text-blue-600 transition">
                        {{ $article['title'] }}
                    </h3>
                    <p class="text-sm text-gray-600">
                        Step-by-step guide to help you get started quickly and efficiently.
                    </p>
                </a>
                @endforeach
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <x-marketing.faq />

    <!-- Contact Support -->
    <section class="py-20 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-2xl p-12 text-white">
                <h2 class="text-3xl font-bold mb-4">
                    Still Need Help?
                </h2>
                <p class="text-xl mb-8 opacity-90">
                    Our support team is here to assist you 24/7
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="mailto:support@aibusinessmarket.com" 
                       class="inline-flex items-center justify-center px-8 py-4 bg-white text-blue-600 font-semibold rounded-lg hover:bg-gray-100 transition">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        Email Support
                    </a>
                    <a href="#" 
                       class="inline-flex items-center justify-center px-8 py-4 bg-transparent border-2 border-white text-white font-semibold rounded-lg hover:bg-white/10 transition">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                        </svg>
                        Live Chat
                    </a>
                </div>
                <p class="text-sm mt-6 opacity-75">
                    Average response time: Under 2 hours
                </p>
            </div>
        </div>
    </section>

    <!-- Cookie Consent -->
    <x-marketing.cookie-consent />
</div>
@endsection