@extends('layouts.marketing')

@section('title', 'Brand Onboarding - AI Business Market')
@section('description', 'Get started with AI Business Market for brands. Connect your accounts, create campaigns, and start working with creators.')

@section('content')
<div x-data="{ step: 1, role: 'brand' }">
    <!-- Progress Bar -->
    <div class="fixed top-0 left-0 right-0 z-40 bg-white border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <div class="flex items-center justify-between mb-2">
                <div class="flex items-center space-x-2">
                    <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.394 2.08a1 1 0 00-.788 0l-7 3a1 1 0 000 1.84L5.25 8.051a.999.999 0 01.356-.257l4-1.714a1 1 0 11.788 1.838L7.667 9.088l1.94.831a1 1 0 00.787 0l7-3a1 1 0 000-1.838l-7-3zM3.31 9.397L5 10.12v4.102a8.969 8.969 0 00-1.05-.174 1 1 0 01-.89-.89 11.115 11.115 0 01.25-3.762zM9.3 16.573A9.026 9.026 0 007 14.935v-3.957l1.818.78a3 3 0 002.364 0l5.508-2.361a11.026 11.026 0 01.25 3.762 1 1 0 01-.89.89 8.968 8.968 0 00-5.35 2.524 1 1 0 01-1.4 0zM6 18a1 1 0 001-1v-2.065a8.935 8.935 0 00-2-.712V17a1 1 0 001 1z"/>
                    </svg>
                    <span class="font-semibold text-gray-900">Brand Onboarding</span>
                </div>
                <span class="text-sm text-gray-600">Step <span x-text="step"></span> of 4</span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2">
                <div class="bg-blue-600 h-2 rounded-full transition-all duration-300" 
                     :style="`width: ${(step / 4) * 100}%`"></div>
            </div>
        </div>
    </div>

    <div class="pt-32 pb-20 min-h-screen bg-gray-50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <!-- Step 1: Welcome -->
            <div x-show="step === 1" x-cloak class="bg-white rounded-2xl shadow-xl p-8 md:p-12">
                <div class="text-center mb-8">
                    <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5"/>
                        </svg>
                    </div>
                    <h1 class="text-4xl font-bold text-gray-900 mb-4">
                        Welcome to AI Business Market!
                    </h1>
                    <p class="text-xl text-gray-600">
                        Let's get your brand set up in just a few minutes
                    </p>
                </div>

                <div class="space-y-6 mb-8">
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-full flex items-center justify-center mr-4">
                            <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-1">Connect Social Accounts</h3>
                            <p class="text-gray-600">Link your brand's social media profiles</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-full flex items-center justify-center mr-4">
                            <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-1">Set Campaign Goals</h3>
                            <p class="text-gray-600">Define what success looks like for your brand</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-full flex items-center justify-center mr-4">
                            <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-1">Invite Team Members</h3>
                            <p class="text-gray-600">Collaborate with your marketing team</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-full flex items-center justify-center mr-4">
                            <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-1">Launch Your First Campaign</h3>
                            <p class="text-gray-600">Start working with creators immediately</p>
                        </div>
                    </div>
                </div>

                <button @click="step = 2" 
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-4 px-6 rounded-lg transition duration-200 text-lg">
                    Let's Get Started
                </button>
            </div>

            <!-- Step 2: Connect Social Accounts -->
            <div x-show="step === 2" x-cloak class="bg-white rounded-2xl shadow-xl p-8 md:p-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-2">
                    Connect Your Social Accounts
                </h2>
                <p class="text-gray-600 mb-8">
                    Link your brand's social media profiles to start managing campaigns
                </p>

                @php
                $platforms = [
                    ['name' => 'Instagram', 'icon' => 'instagram', 'color' => 'pink'],
                    ['name' => 'Facebook', 'icon' => 'facebook', 'color' => 'blue'],
                    ['name' => 'Twitter', 'icon' => 'twitter', 'color' => 'sky'],
                    ['name' => 'LinkedIn', 'icon' => 'linkedin', 'color' => 'blue'],
                    ['name' => 'TikTok', 'icon' => 'tiktok', 'color' => 'gray'],
                    ['name' => 'YouTube', 'icon' => 'youtube', 'color' => 'red']
                ];
                @endphp

                <div class="grid md:grid-cols-2 gap-4 mb-8">
                    @foreach($platforms as $platform)
                    <button class="flex items-center justify-between p-4 border-2 border-gray-200 rounded-lg hover:border-{{ $platform['color'] }}-500 hover:bg-{{ $platform['color'] }}-50 transition duration-200">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-{{ $platform['color'] }}-100 rounded-lg flex items-center justify-center mr-3">
                                <svg class="w-6 h-6 text-{{ $platform['color'] }}-600" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.477 2 2 6.477 2 12c0 5.523 4.477 10 10 10s10-4.477 10-10c0-5.523-4.477-10-10-10z"/>
                                </svg>
                            </div>
                            <span class="font-semibold text-gray-900">{{ $platform['name'] }}</span>
                        </div>
                        <span class="text-sm text-gray-500">Connect</span>
                    </button>
                    @endforeach
                </div>

                <div class="flex gap-4">
                    <button @click="step = 1" 
                            class="flex-1 bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Back
                    </button>
                    <button @click="step = 3" 
                            class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Continue
                    </button>
                </div>

                <p class="text-center text-sm text-gray-500 mt-4">
                    You can skip this step and connect accounts later
                </p>
            </div>

            <!-- Step 3: Campaign Goals -->
            <div x-show="step === 3" x-cloak class="bg-white rounded-2xl shadow-xl p-8 md:p-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-2">
                    What Are Your Campaign Goals?
                </h2>
                <p class="text-gray-600 mb-8">
                    Select your primary objectives (you can change these later)
                </p>

                @php
                $goals = [
                    ['title' => 'Brand Awareness', 'desc' => 'Increase visibility and reach', 'icon' => 'eye'],
                    ['title' => 'Engagement', 'desc' => 'Boost likes, comments, shares', 'icon' => 'heart'],
                    ['title' => 'Lead Generation', 'desc' => 'Capture potential customers', 'icon' => 'users'],
                    ['title' => 'Sales & Conversions', 'desc' => 'Drive purchases and revenue', 'icon' => 'shopping-cart'],
                    ['title' => 'Content Creation', 'desc' => 'Generate user content', 'icon' => 'camera'],
                    ['title' => 'Community Building', 'desc' => 'Grow loyal audience', 'icon' => 'user-group']
                ];
                @endphp

                <div class="grid md:grid-cols-2 gap-4 mb-8">
                    @foreach($goals as $goal)
                    <label class="relative flex items-start p-4 border-2 border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition duration-200 cursor-pointer">
                        <input type="checkbox" class="mt-1 mr-3 h-5 w-5 text-blue-600 rounded focus:ring-blue-500">
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-1">{{ $goal['title'] }}</h3>
                            <p class="text-sm text-gray-600">{{ $goal['desc'] }}</p>
                        </div>
                    </label>
                    @endforeach
                </div>

                <div class="flex gap-4">
                    <button @click="step = 2" 
                            class="flex-1 bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Back
                    </button>
                    <button @click="step = 4" 
                            class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Continue
                    </button>
                </div>
            </div>

            <!-- Step 4: Complete -->
            <div x-show="step === 4" x-cloak class="bg-white rounded-2xl shadow-xl p-8 md:p-12 text-center">
                <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-10 h-10 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                    </svg>
                </div>

                <h2 class="text-4xl font-bold text-gray-900 mb-4">
                    You're All Set!
                </h2>
                <p class="text-xl text-gray-600 mb-8">
                    Your brand account is ready. Let's create your first campaign.
                </p>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-8">
                    <h3 class="font-semibold text-gray-900 mb-3">Quick Tips to Get Started:</h3>
                    <ul class="text-left space-y-2 text-gray-700">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-blue-600 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <span>Use AI to generate campaign proposals in seconds</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-blue-600 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <span>Browse our creator marketplace to find perfect matches</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-blue-600 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <span>Track performance with real-time analytics</span>
                        </li>
                    </ul>
                </div>

                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="{{ route('brand.dashboard') }}" 
                       class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-4 px-8 rounded-lg transition duration-200 text-lg">
                        Go to Dashboard
                    </a>
                    <a href="{{ route('brand.campaigns.create') }}" 
                       class="inline-block bg-white border-2 border-gray-300 text-gray-800 font-semibold py-4 px-8 rounded-lg hover:bg-gray-50 transition duration-200 text-lg">
                        Create Campaign
                    </a>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection