@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-lg shadow-lg p-8 text-center">
            <!-- Cancel Icon -->
            <div class="mb-6">
                <svg class="w-20 h-20 text-red-500 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>

            <h1 class="text-3xl font-bold text-gray-900 mb-4">Payment Cancelled</h1>
            <p class="text-xl text-gray-600 mb-8">Your payment was not completed</p>

            @if(session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    {{ session('error') }}
                </div>
            @endif

            <p class="text-gray-600 mb-8">
                Don't worry! No charges were made to your account. You can try again or choose a different plan.
            </p>

            <div class="space-y-4">
                <a href="{{ route('subscription.plans') }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200">
                    View Plans Again
                </a>
                
                @if(auth()->user()->hasRole('brand_admin'))
                    <a href="{{ route('brand.dashboard') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Go to Dashboard
                    </a>
                @elseif(auth()->user()->hasRole('creator'))
                    <a href="{{ route('creator.dashboard') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Go to Dashboard
                    </a>
                @elseif(auth()->user()->hasRole('agency'))
                    <a href="{{ route('agency.dashboard') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-200">
                        Go to Dashboard
                    </a>
                @endif
            </div>

            <p class="text-sm text-gray-500 mt-6">
                Need help? <a href="mailto:support@example.com" class="text-blue-600 hover:text-blue-700">Contact Support</a>
            </p>
        </div>
    </div>
</div>
@endsection