@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-2xl">
    <div class="bg-white rounded-lg shadow-lg p-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Complete Your Subscription</h1>

        <!-- Plan Summary -->
        <div class="bg-gray-50 rounded-lg p-6 mb-6">
            <h2 class="text-xl font-semibold mb-4">{{ $plan->name }} Plan</h2>
            <div class="space-y-2">
                <div class="flex justify-between">
                    <span class="text-gray-600">Plan Price:</span>
                    <span class="font-semibold">{{ $plan->formatted_price }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Billing Cycle:</span>
                    <span class="font-semibold">{{ ucfirst($plan->interval) }}</span>
                </div>
                @if($plan->hasTrial())
                    <div class="flex justify-between">
                        <span class="text-gray-600">Trial Period:</span>
                        <span class="font-semibold text-green-600">{{ $plan->trial_days }} days free</span>
                    </div>
                @endif
                <div class="border-t pt-2 mt-2">
                    <div class="flex justify-between text-lg">
                        <span class="font-semibold">Total Due Today:</span>
                        <span class="font-bold text-blue-600">{{ $plan->formatted_price }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Features Included -->
        <div class="mb-6">
            <h3 class="font-semibold text-gray-900 mb-3">What's Included:</h3>
            <ul class="space-y-2">
                @foreach($plan->features as $feature)
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                        </svg>
                        <span class="text-gray-700">{{ $feature }}</span>
                    </li>
                @endforeach
            </ul>
        </div>

        <!-- Payment Button -->
        <button id="rzp-button" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-4 px-6 rounded-lg transition duration-200 text-lg">
            @if($plan->hasTrial())
                Start {{ $plan->trial_days }}-Day Free Trial
            @else
                Pay {{ $plan->formatted_price }}
            @endif
        </button>

        <p class="text-center text-sm text-gray-500 mt-4">
            Secure payment powered by Razorpay
        </p>

        <div class="mt-6 text-center">
            <a href="{{ route('subscription.plans') }}" class="text-blue-600 hover:text-blue-700">
                ← Back to Plans
            </a>
        </div>
    </div>
</div>

<!-- Razorpay Checkout Script -->
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
    document.getElementById('rzp-button').onclick = function(e) {
        e.preventDefault();
        
        var options = {
            "key": "{{ $orderData['key_id'] }}",
            "amount": "{{ $orderData['amount'] }}",
            "currency": "{{ $orderData['currency'] }}",
            "name": "{{ config('app.name') }}",
            "description": "{{ $plan->name }} Plan Subscription",
            "order_id": "{{ $orderData['order_id'] }}",
            "handler": function (response) {
                // Send payment details to server for verification
                fetch("{{ route('subscription.process-payment') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        razorpay_payment_id: response.razorpay_payment_id,
                        razorpay_order_id: response.razorpay_order_id,
                        razorpay_signature: response.razorpay_signature,
                        plan_id: {{ $plan->id }}
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.href = "{{ route('subscription.success') }}";
                    } else {
                        window.location.href = "{{ route('subscription.cancel') }}";
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    window.location.href = "{{ route('subscription.cancel') }}";
                });
            },
            "prefill": {
                "name": "{{ auth()->user()->name }}",
                "email": "{{ auth()->user()->email }}",
                "contact": "{{ auth()->user()->phone ?? '' }}"
            },
            "theme": {
                "color": "#3B82F6"
            },
            "modal": {
                "ondismiss": function() {
                    console.log('Payment cancelled by user');
                }
            }
        };
        
        var rzp = new Razorpay(options);
        rzp.open();
    };
</script>
@endsection