@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="text-center mb-12">
        <h1 class="text-4xl font-bold text-gray-900 mb-4">Choose Your Plan</h1>
        <p class="text-xl text-gray-600">Select the perfect plan for your business needs</p>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            {{ session('error') }}
        </div>
    @endif

    @if(session('info'))
        <div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded mb-6">
            {{ session('info') }}
        </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-7xl mx-auto">
        @foreach($plans as $plan)
            <div class="bg-white rounded-lg shadow-lg overflow-hidden {{ $currentPlan && $currentPlan->id === $plan->id ? 'ring-4 ring-blue-500' : '' }}">
                <!-- Plan Header -->
                <div class="bg-gradient-to-r {{ $plan->slug === 'starter' ? 'from-gray-500 to-gray-600' : ($plan->slug === 'pro' ? 'from-blue-500 to-blue-600' : ($plan->slug === 'business' ? 'from-purple-500 to-purple-600' : 'from-yellow-500 to-yellow-600')) }} text-white p-6">
                    <h3 class="text-2xl font-bold mb-2">{{ $plan->name }}</h3>
                    <div class="text-3xl font-bold mb-2">
                        {{ $plan->formatted_price }}
                        @if(!$plan->isFree() && $plan->slug !== 'enterprise')
                            <span class="text-sm font-normal">/{{ $plan->interval }}</span>
                        @endif
                    </div>
                    @if($plan->hasTrial())
                        <p class="text-sm opacity-90">{{ $plan->trial_days }}-day free trial</p>
                    @endif
                </div>

                <!-- Plan Description -->
                <div class="p-6">
                    <p class="text-gray-600 mb-6">{{ $plan->description }}</p>

                    <!-- Features List -->
                    <ul class="space-y-3 mb-6">
                        @foreach($plan->features as $feature)
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-gray-700 text-sm">{{ $feature }}</span>
                            </li>
                        @endforeach
                    </ul>

                    <!-- Feature Limits -->
                    <div class="border-t pt-4 mb-6">
                        <h4 class="font-semibold text-gray-900 mb-3 text-sm">Limits:</h4>
                        <ul class="space-y-2 text-sm text-gray-600">
                            <li>• Social Accounts: {{ $plan->max_social_accounts === -1 ? 'Unlimited' : $plan->max_social_accounts }}</li>
                            <li>• Campaigns: {{ $plan->max_campaigns === -1 ? 'Unlimited' : ($plan->max_campaigns === 0 ? 'None' : $plan->max_campaigns) }}</li>
                            <li>• Proposals: {{ $plan->max_proposals === -1 ? 'Unlimited' : $plan->max_proposals }}/month</li>
                            <li>• Content Ideas: {{ $plan->max_content_ideas_per_month === -1 ? 'Unlimited' : $plan->max_content_ideas_per_month }}/month</li>
                            <li>• Reels: {{ $plan->max_reels_per_month === -1 ? 'Unlimited' : ($plan->max_reels_per_month === 0 ? 'None' : $plan->max_reels_per_month) }}/month</li>
                        </ul>
                    </div>

                    <!-- Action Button -->
                    @if($currentPlan && $currentPlan->id === $plan->id)
                        <button disabled class="w-full bg-gray-300 text-gray-600 font-semibold py-3 px-6 rounded-lg cursor-not-allowed">
                            Current Plan
                        </button>
                    @elseif($subscription && $subscription->isValid())
                        <form action="{{ route('subscription.change-plan', $plan) }}" method="POST">
                            @csrf
                            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200">
                                @if($currentPlan && $plan->price > $currentPlan->price)
                                    Upgrade to {{ $plan->name }}
                                @elseif($currentPlan && $plan->price < $currentPlan->price)
                                    Downgrade to {{ $plan->name }}
                                @else
                                    Switch to {{ $plan->name }}
                                @endif
                            </button>
                        </form>
                    @else
                        <a href="{{ route('subscription.checkout', $plan) }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg text-center transition duration-200">
                            @if($plan->isFree())
                                Get Started Free
                            @elseif($plan->slug === 'enterprise')
                                Contact Sales
                            @else
                                Subscribe Now
                            @endif
                        </a>
                    @endif
                </div>
            </div>
        @endforeach
    </div>

    <!-- FAQ Section -->
    <div class="mt-16 max-w-4xl mx-auto">
        <h2 class="text-3xl font-bold text-center mb-8">Frequently Asked Questions</h2>
        <div class="space-y-4">
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-lg mb-2">Can I change my plan later?</h3>
                <p class="text-gray-600">Yes! You can upgrade or downgrade your plan at any time. Upgrades take effect immediately, while downgrades apply at the end of your current billing period.</p>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-lg mb-2">What payment methods do you accept?</h3>
                <p class="text-gray-600">We accept all major credit/debit cards, UPI, net banking, and wallets through Razorpay.</p>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-lg mb-2">Can I cancel anytime?</h3>
                <p class="text-gray-600">Yes, you can cancel your subscription at any time. You'll continue to have access until the end of your current billing period.</p>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-lg mb-2">Do you offer refunds?</h3>
                <p class="text-gray-600">We offer a 14-day money-back guarantee on all paid plans. Contact support for refund requests.</p>
            </div>
        </div>
    </div>
</div>
@endsection