@extends('layouts.superadmin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Create New Plan</h1>
        <a href="{{ route('superadmin.plans.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Plans
        </a>
    </div>

    <form action="{{ route('superadmin.plans.store') }}" method="POST">
        @csrf
        
        <div class="row">
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header"><h5 class="mb-0">Basic Information</h5></div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Plan Name *</label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required>
                            @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Slug *</label>
                            <input type="text" class="form-control @error('slug') is-invalid @enderror" name="slug" value="{{ old('slug') }}">
                            <small class="text-muted">Leave empty to auto-generate from name</small>
                            @error('slug')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="3">{{ old('description') }}</textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Type *</label>
                                <select class="form-select" name="type" required>
                                    <option value="free">Free</option>
                                    <option value="paid" selected>Paid</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Price *</label>
                                <input type="number" step="0.01" class="form-control" name="price" value="{{ old('price', 0) }}" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Currency *</label>
                                <select class="form-select" name="currency" required>
                                    <option value="INR" selected>INR (₹)</option>
                                    <option value="USD">USD ($)</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Interval *</label>
                                <select class="form-select" name="interval" required>
                                    <option value="monthly" selected>Monthly</option>
                                    <option value="yearly">Yearly</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Trial Days *</label>
                                <input type="number" class="form-control" name="trial_days" value="{{ old('trial_days', 0) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Sort Order</label>
                                <input type="number" class="form-control" name="sort_order" value="{{ old('sort_order', 0) }}">
                            </div>
                        </div>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" name="is_active" value="1" checked>
                            <label class="form-check-label">Active</label>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header"><h5 class="mb-0">Feature Limits (-1 = unlimited, 0 = none)</h5></div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Social Accounts *</label>
                                <input type="number" class="form-control" name="max_social_accounts" value="{{ old('max_social_accounts', 1) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Campaigns *</label>
                                <input type="number" class="form-control" name="max_campaigns" value="{{ old('max_campaigns', 0) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Proposals/Month *</label>
                                <input type="number" class="form-control" name="max_proposals" value="{{ old('max_proposals', 1) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Content Ideas/Month *</label>
                                <input type="number" class="form-control" name="max_content_ideas_per_month" value="{{ old('max_content_ideas_per_month', 5) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Reels/Month *</label>
                                <input type="number" class="form-control" name="max_reels_per_month" value="{{ old('max_reels_per_month', 0) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Max Ad Variants *</label>
                                <input type="number" class="form-control" name="max_ad_variants" value="{{ old('max_ad_variants', 0) }}" required>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header"><h5 class="mb-0">Feature Access</h5></div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_ads_manager" value="1">
                                    <label class="form-check-label">Ads Manager</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_analytics" value="1">
                                    <label class="form-check-label">Analytics</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_competitor_insights" value="1">
                                    <label class="form-check-label">Competitor Insights</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_localization" value="1">
                                    <label class="form-check-label">Localization</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_messaging" value="1">
                                    <label class="form-check-label">Messaging</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_api_access" value="1">
                                    <label class="form-check-label">API Access</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_white_label" value="1">
                                    <label class="form-check-label">White Label</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="has_priority_support" value="1">
                                    <label class="form-check-label">Priority Support</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save"></i> Create Plan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection