
<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Basic Information</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Plan Name *</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $plan->name ?? '') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="slug" class="form-label">Slug *</label>
                    <input type="text" class="form-control @error('slug') is-invalid @enderror" 
                           id="slug" name="slug" value="{{ old('slug', $plan->slug ?? '') }}" required>
                    <small class="form-text text-muted">URL-friendly identifier (e.g., starter, pro, business)</small>
                    @error('slug')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" 
                              id="description" name="description" rows="3">{{ old('description', $plan->description ?? '') }}</textarea>
                    @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="type" class="form-label">Type *</label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="free" {{ old('type', $plan->type ?? '') === 'free' ? 'selected' : '' }}>Free</option>
                            <option value="paid" {{ old('type', $plan->type ?? 'paid') === 'paid' ? 'selected' : '' }}>Paid</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4 mb-3">
                        <label for="price" class="form-label">Price *</label>
                        <input type="number" step="0.01" class="form-control @error('price') is-invalid @enderror" 
                               id="price" name="price" value="{{ old('price', $plan->price ?? 0) }}" required>
                        @error('price')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4 mb-3">
                        <label for="currency" class="form-label">Currency *</label>
                        <select class="form-select @error('currency') is-invalid @enderror" id="currency" name="currency" required>
                            <option value="INR" {{ old('currency', $plan->currency ?? 'INR') === 'INR' ? 'selected' : '' }}>INR (₹)</option>
                            <option value="USD" {{ old('currency', $plan->currency ?? '') === 'USD' ? 'selected' : '' }}>USD ($)</option>
                        </select>
                        @error('currency')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="interval" class="form-label">Billing Interval *</label>
                        <select class="form-select @error('interval') is-invalid @enderror" id="interval" name="interval" required>
                            <option value="monthly" {{ old('interval', $plan->interval ?? 'monthly') === 'monthly' ? 'selected' : '' }}>Monthly</option>
                            <option value="yearly" {{ old('interval', $plan->interval ?? '') === 'yearly' ? 'selected' : '' }}>Yearly</option>
                        </select>
                        @error('interval')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="trial_days" class="form-label">Trial Days *</label>
                        <input type="number" class="form-control @error('trial_days') is-invalid @enderror" 
                               id="trial_days" name="trial_days" value="{{ old('trial_days', $plan->trial_days ?? 0) }}" required>
                        @error('trial_days')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="mb-3">
                    <label for="sort_order" class="form-label">Sort Order</label>
                    <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                           id="sort_order" name="sort_order" value="{{ old('sort_order', $plan->sort_order ?? 0) }}">
                    @error('sort_order')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-check mb-3">
                    <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                           {{ old('is_active', $plan->is_active ?? true) ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_active">Active</label>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Feature Limits</h5>
            </div>
            <div class="card-body">
                <p class="text-muted small mb-3">Use -1 for unlimited, 0 for none</p>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="max_social_accounts" class="form-label">Max Social Accounts *</label>
                        <input type="number" class="form-control" id="max_social_accounts" name="max_social_accounts" 
                               value="{{ old('max_social_accounts', $plan->max_social_accounts ?? 1) }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="max_campaigns" class="form-label">Max Campaigns *</label>
                        <input type="number" class="form-control" id="max_campaigns" name="max_campaigns" 
                               value="{{ old('max_campaigns', $plan->max_campaigns ?? 0) }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="max_proposals" class="form-label">Max Proposals/Month *</label>
                        <input type="number" class="form-control" id="max_proposals" name="max_proposals" 
                               value="{{ old('max_proposals', $plan->max_proposals ?? 1) }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="max_content_ideas_per_month" class="form-label">Max Content Ideas/Month *</label>
                        <input type="number" class="form-control" id="max_content_ideas_per_month" name="max_content_ideas_per_month" 
                               value="{{ old('max_content_ideas_per_month', $plan->max_content_ideas_per_month ?? 5) }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="max_reels_per_month" class="form-label">Max Reels/Month *</label>
                        <input type="number" class="form-control" id="max_reels_per_month" name="max_reels_per_month" 
                               value="{{ old('max_reels_per_month', $plan->max_reels_per_month ?? 0) }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="max_ad_variants" class="form-label">Max Ad Variants *</label>
                        <input type="number" class="form-control" id="max_ad_variants" name="max_ad_variants" 
                               value="{{ old('max_ad_variants', $plan->max_ad_variants ?? 0) }}" required>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Feature Access</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_ads_manager" name="has_ads_manager" value="1" 
                                   {{ old('has_ads_manager', $plan->has_ads_manager ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_ads_manager">Ads Manager</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_analytics" name="has_analytics" value="1" 
                                   {{ old('has_analytics', $plan->has_analytics ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_analytics">Analytics</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_competitor_insights" name="has_competitor_insights" value="1" 
                                   {{ old('has_competitor_insights', $plan->has_competitor_insights ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_competitor_insights">Competitor Insights</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_localization" name="has_localization" value="1" 
                                   {{ old('has_localization', $plan->has_localization ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_localization">Localization</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_messaging" name="has_messaging" value="1" 
                                   {{ old('has_messaging', $plan->has_messaging ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_messaging">Messaging</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_api_access" name="has_api_access" value="1" 
                                   {{ old('has_api_access', $plan->has_api_access ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_api_access">API Access</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_white_label" name="has_white_label" value="1" 
                                   {{ old('has_white_label', $plan->has_white_label ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_white_label">White Label</label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="has_priority_support" name="has_priority_support" value="1" 
                                   {{ old('has_priority_support', $plan->has_priority_support ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="has_priority_support">Priority Support</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Features List</h5>
            </div>
            <div class="card-body">
                <p class="text-muted small mb-3">Add features to display on pricing page (one per line)</p>
                <div id="features-container">
                    @if(isset($plan) && $plan->features)
                        @foreach($plan->features as $index => $feature)
                            <div class="mb-2 feature-item">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="features[]" value="{{ $feature }}" placeholder="Feature description">
                                    <button type="button" class="btn btn-outline-danger remove-feature">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <button type="button" class="btn btn-sm btn-outline-primary" id="add-feature">
                    <i class="fas fa-plus"></i> Add Feature
                </button>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card sticky-top" style="top: 20px;">
            <div class="card-header">
                <h5 class="card-title mb-0">Actions</h5>
            </div>
            <div class="card-body">
                <button type="submit" class="btn btn-primary w-100 mb-2">
                    <i class="fas fa-save"></i> Save Plan
                </button>
                <a href="{{ route('superadmin.plans.index') }}" class="btn btn-outline-secondary w-100">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add feature
    document.getElementById('add-feature').addEventListener('click', function() {
        const container = document.getElementById('features-container');
        const featureItem = document.createElement('div');
        featureItem.className = 'mb-2 feature-item';
        featureItem.innerHTML = `
            <div class="input-group">
                <input type="text" class="form-control" name="features[]" placeholder="Feature description">
                <button type="button" class="btn btn-outline-danger remove-feature">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        container.appendChild(featureItem);
    });

    // Remove feature
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-feature') || e.target.closest('.remove-feature')) {
            const button = e.target.classList.contains('remove-feature') ? e.target : e.target.closest('.remove-feature');
            button.closest('.feature-item').remove();
        }
    });

    // Auto-generate slug from name
    document.getElementById('name').addEventListener('input', function() {
        const slug = this.value.toLowerCase()
            .replace(/[^a-z0-9]+/g, '-')
            .replace(/^-+|-+$/g, '');
        document.getElementById('slug').value = slug;
    });
});
</script>
@endpush