@extends('layouts.superadmin')

@section('content')
<div class="container-fluid">
    <h1 class="h3 mb-4">Razorpay Settings</h1>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif>

    <div class="row">
        <div class="col-md-8">
            <form action="{{ route('superadmin.razorpay.update') }}" method="POST">
                @csrf
                @method('PUT')

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">API Credentials</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Get your API credentials from 
                            <a href="https://dashboard.razorpay.com/app/keys" target="_blank">Razorpay Dashboard</a>
                        </div>

                        <div class="mb-3">
                            <label for="key_id" class="form-label">API Key ID *</label>
                            <input type="text" class="form-control @error('key_id') is-invalid @enderror" 
                                   id="key_id" name="key_id" 
                                   value="{{ $settings->isConfigured() ? '••••••••••••••••' : old('key_id') }}" 
                                   placeholder="rzp_test_xxxxxxxxxxxxx" required>
                            <small class="form-text text-muted">Your Razorpay API Key ID</small>
                            @error('key_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="key_secret" class="form-label">API Key Secret *</label>
                            <input type="password" class="form-control @error('key_secret') is-invalid @enderror" 
                                   id="key_secret" name="key_secret" 
                                   value="{{ $settings->isConfigured() ? '••••••••••••••••' : old('key_secret') }}" 
                                   placeholder="Your secret key" required>
                            <small class="form-text text-muted">Your Razorpay API Key Secret (kept encrypted)</small>
                            @error('key_secret')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="webhook_secret" class="form-label">Webhook Secret</label>
                            <input type="text" class="form-control @error('webhook_secret') is-invalid @enderror" 
                                   id="webhook_secret" name="webhook_secret" 
                                   value="{{ old('webhook_secret', $settings->webhook_secret) }}" 
                                   placeholder="whsec_xxxxxxxxxxxxx">
                            <small class="form-text text-muted">
                                Webhook URL: <code>{{ url('webhooks/razorpay') }}</code>
                            </small>
                            @error('webhook_secret')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Configuration</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="currency" class="form-label">Default Currency *</label>
                            <select class="form-select @error('currency') is-invalid @enderror" 
                                    id="currency" name="currency" required>
                                <option value="INR" {{ $settings->currency === 'INR' ? 'selected' : '' }}>INR (₹)</option>
                                <option value="USD" {{ $settings->currency === 'USD' ? 'selected' : '' }}>USD ($)</option>
                            </select>
                            @error('currency')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="test_mode" name="test_mode" value="1" 
                                   {{ $settings->test_mode ? 'checked' : '' }}>
                            <label class="form-check-label" for="test_mode">
                                Test Mode
                                <small class="text-muted d-block">Use test API keys for testing payments</small>
                            </label>
                        </div>

                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                                   {{ $settings->is_active ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Enable Razorpay
                                <small class="text-muted d-block">Activate payment processing</small>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                    <button type="button" id="test-connection" class="btn btn-outline-secondary">
                        <i class="fas fa-plug"></i> Test Connection
                    </button>
                </div>
            </form>
        </div>

        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Status</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Configuration Status:</strong>
                        <span class="badge bg-{{ $settings->isConfigured() ? 'success' : 'warning' }} ms-2">
                            {{ $settings->isConfigured() ? 'Configured' : 'Not Configured' }}
                        </span>
                    </div>

                    <div class="mb-3">
                        <strong>Razorpay Status:</strong>
                        <span class="badge bg-{{ $settings->is_active ? 'success' : 'secondary' }} ms-2">
                            {{ $settings->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </div>

                    <div class="mb-3">
                        <strong>Mode:</strong>
                        <span class="badge bg-{{ $settings->test_mode ? 'warning' : 'success' }} ms-2">
                            {{ $settings->test_mode ? 'Test' : 'Live' }}
                        </span>
                    </div>

                    <div class="mb-3">
                        <strong>Currency:</strong>
                        <span class="badge bg-info ms-2">{{ $settings->currency }}</span>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Setup Guide</h5>
                </div>
                <div class="card-body">
                    <ol class="small">
                        <li class="mb-2">Login to <a href="https://dashboard.razorpay.com" target="_blank">Razorpay Dashboard</a></li>
                        <li class="mb-2">Go to Settings → API Keys</li>
                        <li class="mb-2">Generate or copy your API keys</li>
                        <li class="mb-2">Paste them in the form above</li>
                        <li class="mb-2">Configure webhook URL in Razorpay:
                            <code class="d-block mt-1">{{ url('webhooks/razorpay') }}</code>
                        </li>
                        <li class="mb-2">Test the connection</li>
                        <li>Enable Razorpay to start accepting payments</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('test-connection').addEventListener('click', function() {
    const btn = this;
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Testing...';

    fetch("{{ route('superadmin.razorpay.test') }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✓ ' + data.message);
        } else {
            alert('✗ ' + data.message);
        }
    })
    .catch(error => {
        alert('✗ Connection test failed: ' + error.message);
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-plug"></i> Test Connection';
    });
});
</script>
@endsection