

<?php $__env->startSection('title', 'Brand Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Brand Dashboard</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('brand.dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <?php endif; ?>

        <!-- KPI Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <!-- Total Followers Card -->
                <?php echo $__env->make('brand.partials._kpi_card', [
                    'title' => 'Total Followers/Subscribers',
                    'value' => number_format(optional($kpis)['followers'] ?? 0),
                    'change' => optional($kpis)['followers_change'] ?? 0,
                    'icon' => 'fa-users',
                    'positive' => optional($kpis)['followers_positive'] ?? null
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Posts Card -->
                <?php echo $__env->make('brand.partials._kpi_card', [
                    'title' => 'Total Posts/Videos',
                    'value' => number_format(optional($kpis)['posts'] ?? 0),
                    'change' => optional($kpis)['posts_change'] ?? 0,
                    'icon' => 'fa-file-alt',
                    'positive' => optional($kpis)['posts_positive'] ?? null
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Views Card -->
                <?php echo $__env->make('brand.partials._kpi_card', [
                    'title' => 'Total Views',
                    'value' => number_format(optional($kpis)['views'] ?? 0),
                    'change' => optional($kpis)['views_change'] ?? 0,
                    'icon' => 'fa-eye',
                    'positive' => optional($kpis)['views_positive'] ?? null
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Engagement Rate Card -->
                <?php echo $__env->make('brand.partials._kpi_card', [
                    'title' => 'Engagement Rate',
                    'value' => number_format(optional($kpis)['engagement'] ?? 0, 2) . '%',
                    'change' => optional($kpis)['engagement_change'] ?? 0,
                    'icon' => 'fa-heart',
                    'positive' => optional($kpis)['engagement_positive'] ?? null
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
        
        <!-- Main Chart -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Views Over Last 14 Days</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                <i class="fas fa-expand"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="viewsChart" height="100"></canvas>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Provider Connection Cards, Recent Posts and AI Tasks -->
        <div class="row">
            <!-- Provider Connection Cards -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Connection Status</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <?php if($connections->count() > 0): ?>
                            <div class="list-group list-group-flush">
                                <?php $__currentLoopData = $connections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $connection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fab fa-<?php echo e($connection->provider); ?> fa-2x mr-2"></i>
                                            <span class="font-weight-bold"><?php echo e(ucfirst($connection->provider)); ?></span>
                                        </div>
                                        <div class="text-right">
                                            <div>
                                                <span class="badge
                                                    <?php if($connection->is_demo): ?> badge-warning
                                                    <?php elseif($connection->isTokenExpired()): ?> badge-danger
                                                    <?php else: ?> badge-success
                                                    <?php endif; ?>">
                                                    <?php if($connection->is_demo): ?> Demo
                                                    <?php elseif($connection->isTokenExpired()): ?> Expired
                                                    <?php else: ?> Connected
                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                <?php echo e(number_format(optional($connection->meta)['followers'] ?? 0)); ?> followers
                                            </small>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            Last synced: <?php echo e($connection->last_synced_at ? $connection->last_synced_at->format('M j, Y H:i') : 'Never'); ?>

                                        </small>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="p-3 text-center">
                                <p class="text-muted">No connections found.</p>
                                <a href="<?php echo e(route('brand.connections.index')); ?>" class="btn btn-primary">Connect Accounts</a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-footer text-center">
                        <a href="<?php echo e(route('brand.connections.index')); ?>" class="btn btn-primary">Manage Connections</a>
                        <form action="<?php echo e(route('brand.dashboard.sync')); ?>" method="POST" class="d-inline" id="syncForm">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success" id="syncButton">
                                <i class="fas fa-sync-alt"></i> Sync Now
                            </button>
                        </form>
                    </div>
                </div>
                
                <!-- AI Tasks Card -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">AI Tasks</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('brand.ai-tasks.generate-proposal')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-robot"></i> Generate AI Proposal
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Recent Posts Grid -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Recent Posts/Videos</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if($recentActivity->count() > 0): ?>
                            <div class="row">
                                <?php $__currentLoopData = $recentActivity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0">
                                                    <?php if(!empty($post->media['thumbnail'])): ?>
                                                        <img src="<?php echo e($post->media['thumbnail']); ?>" alt="Thumbnail" class="img-fluid rounded" style="width: 80px; height: 60px; object-fit: cover;">
                                                    <?php else: ?>
                                                        <div class="bg-light border text-center d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                                            <i class="fas fa-image text-muted"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h6 class="card-title mb-1"><?php echo e(\Illuminate\Support\Str::limit($post->title ?? $post->caption ?? 'No title', 30)); ?></h6>
                                                    <small class="text-muted"><?php echo e(ucfirst($post->socialAccount->provider)); ?></small>
                                                </div>
                                            </div>
                                            
                                            <div class="mt-2">
                                                <span class="badge badge-primary"><?php echo e(number_format($post->getViewsCount())); ?> views</span>
                                                <span class="badge badge-success"><?php echo e(number_format($post->getLikesCount())); ?> likes</span>
                                                <span class="badge badge-warning"><?php echo e(number_format($post->getCommentsCount())); ?> comments</span>
                                            </div>
                                        </div>
                                        <div class="card-footer">
                                            <button type="button" class="btn btn-sm btn-outline-info" data-toggle="modal" data-target="#postModal<?php echo e($post->id); ?>">
                                                View Details
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Post Detail Modal -->
                                <div class="modal fade" id="postModal<?php echo e($post->id); ?>" tabindex="-1" role="dialog">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title"><?php echo e($post->title ?? $post->caption ?? 'Post Details'); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <?php if(!empty($post->media['thumbnail'])): ?>
                                                            <img src="<?php echo e($post->media['thumbnail']); ?>" alt="Thumbnail" class="img-fluid rounded">
                                                        <?php else: ?>
                                                            <div class="bg-light border text-center p-3">
                                                                <i class="fas fa-image fa-3x text-muted"></i>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <p><strong>Published:</strong> <?php echo e($post->published_at ? $post->published_at->format('M j, Y H:i') : 'N/A'); ?></p>
                                                        <p><strong>Platform:</strong> <?php echo e(ucfirst($post->socialAccount->provider)); ?></p>
                                                        <p><strong>Views:</strong> <?php echo e(number_format($post->getViewsCount())); ?></p>
                                                        <p><strong>Likes:</strong> <?php echo e(number_format($post->getLikesCount())); ?></p>
                                                        <p><strong>Comments:</strong> <?php echo e(number_format($post->getCommentsCount())); ?></p>
                                                        <p><strong>Shares:</strong> <?php echo e(number_format($post->getSharesCount())); ?></p>
                                                        
                                                        <?php if($post->content): ?>
                                                        <div class="mt-3">
                                                            <strong>Content:</strong>
                                                            <p><?php echo e($post->content); ?></p>
                                                        </div>
                                                        <?php endif; ?>
                                                        
                                                        <?php if($post->permalink): ?>
                                                        <div class="mt-3">
                                                            <a href="<?php echo e($post->permalink); ?>" target="_blank" class="btn btn-primary">
                                                                View on <?php echo e(ucfirst($post->socialAccount->provider)); ?>

                                                            </a>
                                                        </div>
                                                        <?php endif; ?>
                                                        
                                                        <div class="mt-3">
                                                            <strong>Raw Data:</strong>
                                                            <pre class="bg-light p-2 rounded"><?php echo e(json_encode($post->raw_json, JSON_PRETTY_PRINT)); ?></pre>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center p-3">
                                <p class="text-muted">No recent posts found.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- AI Tasks List -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Recent AI Tasks</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <?php if($aiTasks->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Created</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $aiTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(ucfirst(str_replace('_', ' ', $task->type))); ?></td>
                                            <td>
                                                <span class="badge
                                                    <?php if($task->status === 'pending'): ?> badge-warning
                                                    <?php elseif($task->status === 'processing'): ?> badge-info
                                                    <?php elseif($task->status === 'completed'): ?> badge-success
                                                    <?php elseif($task->status === 'failed'): ?> badge-danger
                                                    <?php else: ?> badge-secondary
                                                    <?php endif; ?>">
                                                    <?php echo e(ucfirst($task->status)); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($task->created_at->format('M j, Y H:i')); ?></td>
                                            <td>
                                                <?php if($task->result_text): ?>
                                                    <button type="button" class="btn btn-xs btn-outline-primary" data-toggle="modal" data-target="#resultModal<?php echo e($task->id); ?>">
                                                        View Result
                                                    </button>
                                                    
                                                    <!-- Result Modal -->
                                                    <div class="modal fade" id="resultModal<?php echo e($task->id); ?>" tabindex="-1" role="dialog">
                                                        <div class="modal-dialog modal-lg" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title">AI Task Result</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <pre><?php echo e($task->result_text); ?></pre>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-muted">No result yet</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="p-3 text-center">
                                <p class="text-muted">No AI tasks found.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/brand-dashboard.js')); ?>" type="module"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Fetch stats data and render chart
        fetch('<?php echo e(route('brand.dashboard.stats')); ?>')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                // Check if data is valid before rendering
                if (data && data.labels && data.data) {
                    renderViewsChart('viewsChart', data.labels, data.data);
                } else {
                    console.warn('Invalid data received for chart:', data);
                }
            })
            .catch(error => {
                console.error('Error fetching stats data:', error);
                // Show error message to user
                showSyncToast('Failed to load chart data. Please try again later.', 'danger');
            });
            
        // Handle sync button click
        handleSyncButtonClick();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\AI business market\Laravel\resources\views/brand/dashboard.blade.php ENDPATH**/ ?>