<?php

// Simple test script to verify reel feature implementation

echo "=== Reel Feature Implementation Verification ===\n\n";

// Check if required files exist
$requiredFiles = [
    'app/Models/ReelRequest.php',
    'app/Models/ReelInput.php',
    'app/Http/Controllers/Brand/ReelController.php',
    'app/Http/Controllers/Creator/ReelController.php',
    'app/Http/Controllers/Api/ReelController.php',
    'app/Http/Requests/StoreReelRequest.php',
    'app/Jobs/SendReelToProcessor.php',
    'app/Jobs/HandleReelCallback.php',
    'app/Notifications/ReelCompletedNotification.php',
    'config/reels.php',
    'resources/views/brand/reels/index.blade.php',
    'resources/views/brand/reels/create.blade.php',
    'resources/views/brand/reels/show.blade.php',
    'resources/views/creator/reels/index.blade.php',
    'resources/views/creator/reels/create.blade.php',
    'resources/views/creator/reels/show.blade.php',
    'resources/js/reels.js',
    'database/factories/ReelRequestFactory.php',
    'database/factories/ReelInputFactory.php',
    'database/seeders/ReelsDemoSeeder.php',
];

echo "Checking required files:\n";
$allFilesExist = true;
foreach ($requiredFiles as $file) {
    if (file_exists($file)) {
        echo "  ✓ $file\n";
    } else {
        echo "  ✗ $file (MISSING)\n";
        $allFilesExist = false;
    }
}

echo "\n";

// Check if required directories exist
$requiredDirs = [
    'app/Helpers',
    'curl_examples',
];

echo "Checking required directories:\n";
foreach ($requiredDirs as $dir) {
    if (is_dir($dir)) {
        echo "  ✓ $dir\n";
    } else {
        echo "  ✗ $dir (MISSING)\n";
    }
}

echo "\n";

// Check if helper file exists
$helperFile = 'app/Helpers/ReelHelper.php';
if (file_exists($helperFile)) {
    echo "✓ Helper file exists: $helperFile\n";
} else {
    echo "✗ Helper file missing: $helperFile\n";
}

echo "\n";

// Check if curl examples exist
$curlExamples = [
    'curl_examples/reel_callback.sh',
    'curl_examples/reel_callback.bat',
];

echo "Checking curl examples:\n";
foreach ($curlExamples as $example) {
    if (file_exists($example)) {
        echo "  ✓ $example\n";
    } else {
        echo "  ✗ $example (MISSING)\n";
    }
}

echo "\n";

// Check if verification steps file exists
$verificationFile = 'verification_steps.md';
if (file_exists($verificationFile)) {
    echo "✓ Verification steps file exists: $verificationFile\n";
} else {
    echo "✗ Verification steps file missing: $verificationFile\n";
}

echo "\n";

// Check if routes are properly defined
$routeOutput = shell_exec('php artisan route:list | findstr reel');
if ($routeOutput) {
    echo "✓ Reel routes are properly defined:\n";
    echo $routeOutput;
} else {
    echo "✗ Reel routes are not properly defined\n";
}

echo "\n";

// Check if migrations have been run
$migrationOutput = shell_exec('php artisan migrate:status | findstr reel');
if (strpos($migrationOutput, 'Ran') !== false) {
    echo "✓ Reel migrations have been run successfully\n";
} else {
    echo "✗ Reel migrations have not been run\n";
}

echo "\n";

// Check if seeder has been run
// We can't directly check this, but we can check if the tables have data
echo "Checking if reel tables exist and have data:\n";
try {
    // This would require a database connection, so we'll just check if the tables exist
    echo "  Note: To fully verify, you would need to check the database tables directly\n";
    echo "  Tables to check: reel_requests, reel_inputs\n";
} catch (Exception $e) {
    echo "  Error checking database: " . $e->getMessage() . "\n";
}

echo "\n";

echo "=== Verification Complete ===\n";
echo "If all checks passed, the reel feature implementation is complete!\n";