<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Illuminate\Support\Facades\Artisan;

/**
 * Combined test runner for social conditional tests.
 * यह टेस्ट Brand और Creator दोनों के conditional टेस्ट एक साथ चलाता है।
 * यह केवल wrapper है — असली tests अलग-अलग files में बने रहेंगे।
 */
class AllSocialConditionalTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        // Ensure APP_KEY
        if (empty(config('app.key'))) {
            Artisan::call('key:generate');
        }

        config(['queue.default' => 'sync']);

        // seed role & demo data for both suites
        $this->seed(\Database\Seeders\RolePermissionSeeder::class);
        $this->seed(\Database\Seeders\SocialDemoSeeder::class);
    }

    /** @test */
    public function run_brand_social_conditional_suite()
    {
        // call the Brand test class methods via Artisan phpunit invocation for clarity
        // This executes the BrandSocialConditionalTest isolated
        $exit = null;
        $output = null;
        exec('php vendor/phpunit/phpunit/phpunit tests/Feature/BrandSocialConditionalTest.php --colors=never', $output, $exit);
        $this->assertEquals(0, $exit, 'BrandSocialConditionalTest failed: ' . implode("\n", $output));
    }

    /** @test */
    public function run_creator_social_conditional_suite()
    {
        // execute Creator tests file
        $exit = null;
        $output = null;
        exec('php vendor/phpunit/phpunit/phpunit tests/Feature/CreatorSocialConditionalTest.php --colors=never', $output, $exit);
        $this->assertEquals(0, $exit, 'CreatorSocialConditionalTest failed: ' . implode("\n", $output));
    }
}