<?php

namespace Tests;

use Database\Seeders\RolePermissionSeeder;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use Illuminate\Support\Facades\Artisan;

abstract class TestCase extends BaseTestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        
        // Ensure APP_KEY is set
        if (empty(config('app.key'))) {
            Artisan::call('key:generate');
        }
        
        // Use sync queue in tests
        config(['queue.default' => 'sync']);
        
        // Run role permission seeder
        $this->seed(RolePermissionSeeder::class);
    }
}
