<?php

namespace App\Http\Controllers\Creator;

use App\Http\Controllers\Controller;
use App\Http\Requests\Creator\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class ProfileController extends Controller
{
    /**
     * Display the creator's profile form.
     */
    public function edit(Request $request): View
    {
        return view('creator.profile.edit', [
            'user' => $request->user(),
        ]);
    }

    /**
     * Update the creator's profile information.
     */
    public function update(ProfileUpdateRequest $request): RedirectResponse
    {
        $user = $request->user();
        
        // Update basic user information
        $user->fill($request->validated());
        
        // Handle bio and avatar from meta field
        $meta = $user->meta ?? [];
        
        if ($request->filled('bio')) {
            $meta['bio'] = $request->bio;
        }
        
        // Handle avatar upload
        if ($request->hasFile('avatar')) {
            $avatarPath = $request->file('avatar')->store('avatars', 'public');
            $meta['avatar'] = $avatarPath;
        }
        
        // Handle niche/categories (multi-select)
        if ($request->has('niche')) {
            $meta['niche'] = $request->niche;
        }
        
        // Handle audience demographics
        if ($request->filled('audience_age')) {
            $meta['audience_age'] = $request->audience_age;
        }
        
        if ($request->filled('audience_gender')) {
            $meta['audience_gender'] = $request->audience_gender;
        }
        
        if ($request->has('audience_location')) {
            $meta['audience_location'] = $request->audience_location;
        }
        
        $user->meta = $meta;
        
        // Handle influencer type
        $user->influencer_type = $request->influencer_type;
        if ($request->influencer_type === 'Other' && $request->filled('influencer_type_custom')) {
            $user->influencer_type_custom = $request->influencer_type_custom;
        } else {
            $user->influencer_type_custom = null;
        }
        
        if ($user->isDirty('email')) {
            $user->email_verified_at = null;
        }
        
        $user->save();
        
        return Redirect::route('creator.profile.edit')->with('status', 'profile-updated');
    }
}