<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Content;
use Illuminate\Http\Request;
use Illuminate\View\View;

class LibraryController extends Controller
{
    /**
     * Display the user's content library.
     */
    public function index(Request $request): View
    {
        // Get published content accessible to the user
        // In a real application, you might filter by tenant, subscription, etc.
        $contentItems = Content::published()
            ->whereHas('brand', function ($query) use ($request) {
                $query->where('tenant_id', $request->user()->tenant_id);
            })
            ->get();

        return view('user.library', [
            'contentItems' => $contentItems,
        ]);
    }
}