<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class StoreScheduledReelRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'source_inputs' => 'required|array|min:1',
            'template' => 'required|string|in:' . implode(',', array_keys(config('reels.templates', []))),
            'options' => 'nullable|array',
            'options.aspect_ratio' => 'nullable|string|in:9:16,1:1,4:5',
            'options.music' => 'nullable|string|max:255',
            'options.overlay' => 'nullable|string|max:255',
            'scheduled_at' => 'nullable|date',
            'timezone' => 'nullable|string|timezone',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     */
    public function messages(): array
    {
        return [
            'source_inputs.required' => 'Please select at least one source post or video.',
            'template.required' => 'Please select a template for your reel.',
            'template.in' => 'The selected template is invalid.',
            'scheduled_at.date' => 'The scheduled date and time must be a valid date.',
            'timezone.timezone' => 'The selected timezone is invalid.',
        ];
    }
}