<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Content extends Model
{
    protected $fillable = [
        'brand_id',
        'creator_id',
        'title',
        'body',
        'status',
    ];
    
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
    
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
    
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }
    
    public function scopePublished($query)
    {
        return $query->where('status', 'published');
    }
}
