<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contract extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'proposal_id',
        'brand_id',
        'creator_id',
        'title',
        'description',
        'terms',
        'start_date',
        'end_date',
        'value',
        'currency',
        'status',
        'brand_signature',
        'brand_signed_at',
        'creator_signature',
        'creator_signed_at',
        'document_path',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'value' => 'decimal:2',
        'brand_signed_at' => 'datetime',
        'creator_signed_at' => 'datetime',
    ];

    /**
     * Get the proposal that owns the contract.
     */
    public function proposal()
    {
        return $this->belongsTo(Proposal::class);
    }

    /**
     * Get the brand that owns the contract.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the creator that owns the contract.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }

    /**
     * Get the payments for the contract.
     */
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}