<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invite extends Model
{
    protected $fillable = [
        'tenant_id',
        'email',
        'token',
        'role',
        'expires_at',
        'used',
    ];
    
    protected $casts = [
        'expires_at' => 'datetime',
        'used' => 'boolean',
    ];
    
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
