<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Proposal;

class WorkDelivered extends Notification
{
    use Queueable;

    protected $proposal;

    /**
     * Create a new notification instance.
     *
     * @param Proposal $proposal
     * @return void
     */
    public function __construct(Proposal $proposal)
    {
        $this->proposal = $proposal;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Work Delivered for Proposal: ' . $this->proposal->title)
                    ->greeting('Hello ' . $notifiable->name . '!')
                    ->line('The work for your proposal has been delivered: ' . $this->proposal->title)
                    ->line('Please review the deliverables and provide feedback.')
                    ->action('View Deliverables', url('/brand/proposals/' . $this->proposal->id))
                    ->line('Thank you for using our platform!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'proposal_id' => $this->proposal->id,
            'proposal_title' => $this->proposal->title,
            'message' => 'The work for your proposal has been delivered: ' . $this->proposal->title,
        ];
    }
}