<?php

namespace App\Services\SocialProviders;

use App\Models\SocialAccount;
use Illuminate\Support\Facades\Config;

class TwitterProvider extends BaseProvider
{
    /**
     * Configure the provider.
     *
     * @return void
     */
    protected function configure()
    {
        $this->slug = 'twitter';
        $this->name = 'Twitter';
        
        $this->endpoints = [
            'authorize' => 'https://twitter.com/i/oauth2/authorize',
            'token' => 'https://api.twitter.com/2/oauth2/token',
            'api' => 'https://api.twitter.com/2',
        ];
        
        $this->scopes = [
            'users.read',
            'tweet.read',
        ];
        
        $this->clientId = Config::get('services.twitter.client_id');
        $this->clientSecret = Config::get('services.twitter.client_secret');
        $this->redirectUri = route('creator.connections.callback', ['provider' => 'twitter']);
    }

    /**
     * Get user info using the access token.
     *
     * @param string $token
     * @return array
     */
    protected function getUserInfo($token)
    {
        // TODO: Implement Twitter API v2 user info endpoint
        // https://developer.twitter.com/en/docs/twitter-api/users/lookup/api-reference/get-users-me
        // Example:
        // $url = $this->endpoints['api'] . '/users/me?user.fields=public_metrics,profile_image_url';
        // $response = $this->httpClient->get($url, [
        //     'headers' => [
        //         'Authorization' => 'Bearer ' . $token,
        //     ],
        // ]);
        // return json_decode($response->getBody(), true);
        
        return [];
    }

    /**
     * Fetch account details from the provider.
     *
     * @param SocialAccount $account
     * @return array
     */
    public function fetchAccountDetails(SocialAccount $account): array
    {
        // For demo accounts, return fake data
        if ($account->is_demo) {
            return [
                'id' => $account->provider_user_id,
                'name' => 'Demo Twitter Account',
                'username' => 'demo_twitter',
                'followers' => 15000,
                'following' => 1200,
                'tweets' => 5420,
                'profile_image_url' => 'https://placehold.co/400x400',
            ];
        }

        // TODO: Implement Twitter API v2 to fetch account details
        // https://developer.twitter.com/en/docs/twitter-api/users/lookup/api-reference/get-users-by-username-username
        // Example:
        // try {
        //     $url = $this->endpoints['api'] . '/users/by/username/' . $account->meta['username'] . '?user.fields=public_metrics,profile_image_url';
        //     $response = $this->makeApiRequest($account, $url);
        //     
        //     $user = $response['data'];
        //     
        //     return [
        //         'id' => $user['id'],
        //         'name' => $user['name'],
        //         'username' => $user['username'],
        //         'followers' => $user['public_metrics']['followers_count'],
        //         'following' => $user['public_metrics']['following_count'],
        //         'tweets' => $user['public_metrics']['tweet_count'],
        //         'profile_image_url' => $user['profile_image_url'],
        //     ];
        // } catch (\Exception $e) {
        //     $this->logRequestException($e, 'Failed to fetch Twitter account details', $account);
        //     return [];
        // }
        
        return [];
    }

    /**
     * Fetch recent posts from the provider.
     *
     * @param SocialAccount $account
     * @param int $limit
     * @return array
     */
    public function fetchRecentPosts(SocialAccount $account, int $limit = 20): array
    {
        // For demo accounts, return fake data
        if ($account->is_demo) {
            $posts = [];
            for ($i = 1; $i <= min($limit, 10); $i++) {
                $posts[] = [
                    'id' => 'demo_tweet_' . $i,
                    'text' => 'This is a demo tweet #' . $i . ' with some content to show how it would look.',
                    'created_at' => now()->subHours($i)->toIso8601String(),
                    'retweet_count' => rand(10, 500),
                    'like_count' => rand(20, 1000),
                    'reply_count' => rand(5, 100),
                    'quote_count' => rand(2, 50),
                ];
            }
            return $posts;
        }

        // TODO: Implement Twitter API v2 to fetch recent tweets
        // https://developer.twitter.com/en/docs/twitter-api/tweets/timelines/api-reference/get-users-id-tweets
        // Example:
        // try {
        //     $url = $this->endpoints['api'] . '/users/' . $account->provider_user_id . '/tweets?max_results=' . $limit . '&tweet.fields=public_metrics,created_at';
        //     $response = $this->makeApiRequest($account, $url);
        //     
        //     $tweets = [];
        //     foreach ($response['data'] as $tweet) {
        //         $tweets[] = [
        //             'id' => $tweet['id'],
        //             'text' => $tweet['text'],
        //             'created_at' => $tweet['created_at'],
        //             'retweet_count' => $tweet['public_metrics']['retweet_count'],
        //             'like_count' => $tweet['public_metrics']['like_count'],
        //             'reply_count' => $tweet['public_metrics']['reply_count'],
        //             'quote_count' => $tweet['public_metrics']['quote_count'],
        //         ];
        //     }
        //     
        //     return $tweets;
        // } catch (\Exception $e) {
        //     $this->logRequestException($e, 'Failed to fetch Twitter tweets', $account);
        //     return [];
        // }
        
        return [];
    }
}