<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withProviders([
        \App\Providers\AuthServiceProvider::class,
    ])
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
            $middleware->web(append: [
                \App\Http\Middleware\IdentifyTenant::class,
            ]);
            
            // Register the SuperAdmin middleware
            $middleware->alias([
                'isSuperAdmin' => \App\Http\Middleware\isSuperAdmin::class,
                'reel.rate.limit' => \App\Http\Middleware\ReelRateLimit::class,
                'throttle_social_publishing' => \App\Http\Middleware\ThrottleSocialPublishing::class,
                'subscription' => \App\Http\Middleware\CheckSubscription::class,
                'feature' => \App\Http\Middleware\CheckFeatureAccess::class,
            ]);
        })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
