<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Python Microservice Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for connecting Laravel with Python AI Microservice
    |
    */

    'api' => [
        'base_url' => env('PYTHON_API_URL', 'http://localhost:8000'),
        'api_key' => env('PYTHON_API_KEY'),
        'timeout' => env('PYTHON_API_TIMEOUT', 30),
        'retry_times' => env('PYTHON_API_RETRY_TIMES', 3),
        'retry_delay' => env('PYTHON_API_RETRY_DELAY', 1000), // milliseconds
    ],

    'callback' => [
        'secret' => env('PYTHON_CALLBACK_SECRET'),
        'verify_signature' => env('PYTHON_VERIFY_SIGNATURE', true),
    ],

    'endpoints' => [
        'ai_jobs' => '/v1/ai/jobs',
        'ai_job_status' => '/v1/ai/jobs/{job_id}',
        'publish' => '/v1/publish',
        'publish_status' => '/v1/publish/{job_id}',
        'rag_ingest' => '/v1/rag/ingest',
        'rag_query' => '/v1/rag/query',
        'reels_process' => '/v1/reels/process',
        'health' => '/health/readiness',
    ],

    'job_types' => [
        'proposal' => 'proposal',
        'content_ideas' => 'content_ideas',
        'auto_reply' => 'auto_reply',
        'ads_generate' => 'ads_generate',
        'forecast' => 'forecast',
        'matchmaking' => 'matchmaking',
        'translate' => 'translate',
        'contract_draft' => 'contract_draft',
        'support_rag' => 'support_rag',
        'custom' => 'custom',
    ],

    'social_platforms' => [
        'twitter' => 'twitter',
        'facebook' => 'facebook',
        'instagram' => 'instagram',
        'linkedin' => 'linkedin',
        'youtube' => 'youtube',
    ],

    'features' => [
        'ai_enabled' => env('PYTHON_AI_ENABLED', true),
        'publishing_enabled' => env('PYTHON_PUBLISHING_ENABLED', true),
        'rag_enabled' => env('PYTHON_RAG_ENABLED', true),
        'reels_enabled' => env('PYTHON_REELS_ENABLED', true),
    ],

    'logging' => [
        'enabled' => env('PYTHON_LOG_REQUESTS', true),
        'channel' => env('PYTHON_LOG_CHANNEL', 'stack'),
    ],

];