<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Reels Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for the reels feature.
    |
    */

    'templates' => [
        'template_1' => [
            'name' => 'Standard Reel',
            'description' => 'A standard reel with basic transitions and effects',
        ],
        'template_2' => [
            'name' => 'Dynamic Reel',
            'description' => 'A dynamic reel with advanced transitions and animations',
        ],
        'template_3' => [
            'name' => 'Story Reel',
            'description' => 'A story-style reel with text overlays and stickers',
        ],
    ],

    'providers' => [
        'instagram' => [
            'name' => 'Instagram',
            'enabled' => true,
        ],
        'youtube' => [
            'name' => 'YouTube',
            'enabled' => true,
        ],
        'tiktok' => [
            'name' => 'TikTok',
            'enabled' => true,
        ],
        'linkedin' => [
            'name' => 'LinkedIn',
            'enabled' => true,
        ],
    ],

    'signed_url_expire' => env('REEL_SIGNED_URL_EXPIRE', 300),

    'post_rate_limit_per_day' => env('REEL_POST_RATE_LIMIT_PER_DAY', 10),

    'max_concurrent_per_owner' => env('REEL_MAX_CONCURRENT_PER_OWNER', 3),

    'processor_url' => env('REEL_PROCESSOR_URL', 'https://reel-processor.example.com/process'),

    'processor_secret' => env('REEL_PROCESSOR_SECRET', 'your-reel-processor-secret'),
];