<?php

namespace Database\Factories;

use App\Models\Campaign;
use App\Models\Brand;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class CampaignFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Campaign::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'agency_id' => User::factory(),
            'brand_id' => Brand::factory(),
            'name' => $this->faker->sentence(3),
            'start_date' => $this->faker->date(),
            'end_date' => $this->faker->date(),
            'budget' => $this->faker->randomFloat(2, 1000, 10000),
            'status' => $this->faker->randomElement(['draft', 'active', 'paused', 'completed', 'cancelled']),
        ];
    }
}