<?php

namespace Database\Factories;

use App\Models\Payment;
use App\Models\Contract;
use App\Models\Proposal;
use App\Models\Brand;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class PaymentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Payment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
   {
       // Get existing records or create new ones if none exist
       $contract = Contract::inRandomOrder()->first() ?? Contract::factory()->create();
       $proposal = Proposal::inRandomOrder()->first() ?? Proposal::factory()->create();
       $brand = Brand::inRandomOrder()->first() ?? Brand::factory()->create();
       $creator = User::whereHas('roles', function ($q) {
           $q->where('name', 'creator');
       })->inRandomOrder()->first() ?? User::factory()->create();
       
       return [
           'contract_id' => $contract->id,
           'proposal_id' => $proposal->id,
           'brand_id' => $brand->id,
           'creator_id' => $creator->id,
           'amount' => $this->faker->randomFloat(2, 100, 10000),
           'currency' => 'USD',
           'payment_method' => $this->faker->randomElement(['credit_card', 'bank_transfer', 'paypal']),
           'status' => $this->faker->randomElement(['pending', 'processing', 'completed', 'failed', 'refunded']),
           'transaction_id' => $this->faker->uuid,
           'notes' => $this->faker->sentence,
           'paid_at' => $this->faker->dateTime(),
       ];
   }
}