<?php

namespace Database\Factories;

use App\Models\Proposal;
use App\Models\Brand;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProposalFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Proposal::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
   {
       // Get existing records or create new ones if none exist
       $brand = Brand::inRandomOrder()->first() ?? Brand::factory()->create();
       $creator = User::whereHas('roles', function ($q) {
           $q->where('name', 'creator');
       })->inRandomOrder()->first() ?? User::factory()->create();
       
       return [
           'brand_id' => $brand->id,
           'creator_id' => $creator->id,
           'contract_id' => null,
           'payment_id' => null,
           'title' => $this->faker->sentence,
           'message' => $this->faker->paragraph,
           'type' => $this->faker->randomElement(['Collaboration', 'Sponsored Post', 'Affiliate', 'Long-term Partnership']),
           'budget' => $this->faker->randomFloat(2, 100, 10000),
           'duration' => $this->faker->randomElement(['1 week', '2 weeks', '1 month', '3 months']),
           'deliverables' => $this->faker->randomElements(['Instagram post', 'Instagram story', 'YouTube video', 'TikTok video', 'Blog post'], $this->faker->numberBetween(1, 3)),
           'attachment_path' => null,
           'status' => $this->faker->randomElement(['sent', 'draft', 'accepted', 'rejected', 'contract_sent', 'contract_signed', 'payment_made', 'delivered']),
           'read_at' => $this->faker->optional()->dateTime(),
           'expires_at' => $this->faker->optional()->dateTime(),
           'response_deadline' => $this->faker->optional()->dateTime(),
           'terms' => $this->faker->optional()->text,
           'signed_at' => $this->faker->optional()->dateTime(),
           'delivered_at' => $this->faker->optional()->dateTime(),
           'delivery_notes' => $this->faker->optional()->text,
           'rating' => $this->faker->optional()->randomFloat(2, 1, 5),
           'review' => $this->faker->optional()->text,
       ];
   }
}