<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_posts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('social_account_id');
            $table->string('provider_post_id');
            $table->string('title')->nullable();
            $table->text('caption')->nullable();
            $table->longText('content')->nullable();
            $table->json('media')->nullable();
            $table->string('permalink')->nullable();
            $table->timestamp('published_at')->nullable();
            $table->json('metrics')->nullable(); // views, likes, comments, shares
            $table->json('raw_json')->nullable();
            $table->timestamp('last_checked_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('social_account_id');
            $table->index('provider_post_id');
            $table->index('published_at');
            
            // Foreign key
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_posts');
    }
};
