<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_aggregates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->unsignedBigInteger('tenant_id')->nullable();
            $table->string('provider')->nullable(); // nullable for overall aggregates
            $table->string('key'); // e.g., 'followers', 'total_posts', 'total_views'
            $table->json('value')->nullable(); // numeric or json data
            $table->timestamp('computed_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'provider']);
            $table->index(['brand_id', 'key']);
            $table->index(['tenant_id', 'key']);
            $table->index('key');
            
            // Foreign keys
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_aggregates');
    }
};
