<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_sync_errors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('social_account_id')->nullable();
            $table->text('error_text');
            $table->unsignedSmallInteger('response_code')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps(); // This will add both created_at and updated_at
            
            // Indexes
            $table->index('social_account_id');
            $table->index('response_code');
            $table->index('created_at');
            
            // Foreign key
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_sync_errors');
    }
};
