<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contracts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('proposal_id');
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('creator_id');
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('terms');
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('value', 10, 2);
            $table->string('currency', 3)->default('USD');
            $table->enum('status', ['draft', 'sent', 'signed', 'active', 'completed', 'terminated'])->default('draft');
            $table->text('brand_signature')->nullable();
            $table->timestamp('brand_signed_at')->nullable();
            $table->text('creator_signature')->nullable();
            $table->timestamp('creator_signed_at')->nullable();
            $table->string('document_path')->nullable();
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('proposal_id')->references('id')->on('proposals')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index('brand_id');
            $table->index('creator_id');
            $table->index('status');
            $table->index('start_date');
            $table->index('end_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contracts');
    }
};
