<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proposal_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('creator_id')->nullable();
            $table->text('campaign_brief');
            $table->string('tone')->nullable();
            $table->json('budget_range')->nullable();
            $table->json('deliverables')->nullable();
            $table->string('status')->default('pending'); // pending, processing, completed, failed
            $table->unsignedBigInteger('ai_job_id')->nullable();
            $table->timestamps();
            
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('ai_job_id')->references('id')->on('ai_jobs')->onDelete('set null');
            
            $table->index(['brand_id', 'status']);
            $table->index('creator_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proposal_requests');
    }
};