<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('proposals', function (Blueprint $table) {
            $table->unsignedBigInteger('ai_job_id')->nullable()->after('creator_id');
            $table->foreign('ai_job_id')->references('id')->on('ai_jobs')->onDelete('set null');
            $table->index('ai_job_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('proposals', function (Blueprint $table) {
            $table->dropForeign(['ai_job_id']);
            $table->dropIndex(['ai_job_id']);
            $table->dropColumn('ai_job_id');
        });
    }
};