<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proposal_section_audits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('proposal_section_id');
            $table->unsignedBigInteger('user_id');
            $table->string('action'); // edit, accept, regenerate, etc.
            $table->longText('old_content')->nullable();
            $table->longText('new_content')->nullable();
            $table->timestamps();
            
            $table->foreign('proposal_section_id')->references('id')->on('proposal_sections')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            $table->index(['proposal_section_id', 'created_at']);
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proposal_section_audits');
    }
};