<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if creator_id column exists before adding it
            if (!Schema::hasColumn('auto_reply_suggestions', 'creator_id')) {
                // Add creator_id column
                $table->unsignedBigInteger('creator_id')->nullable()->after('brand_id');
                
                // Add foreign key constraint for creator_id
                $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if creator_id column exists before dropping it
            if (Schema::hasColumn('auto_reply_suggestions', 'creator_id')) {
                // Remove the added columns and constraints
                $table->dropForeign(['creator_id']);
                $table->dropColumn('creator_id');
            }
        });
    }
};
